package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.ibecorp.correspondence.rules.NotificationProperties
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent
import com.gridnine.xtrip.common.model.profile.ModelContractIndex
import com.gridnine.xtrip.common.rules.RuleSet
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SearchResult
import com.gridnine.xtrip.common.util.TextUtil

import java.util.stream.Collectors

doJob()

protected void doJob() throws Exception {
    SearchResult<ModelContractIndex> searchResult = EntityStorage.get().search(ModelContractIndex.class, new SearchQuery())
    List<String> contractNames = getContractNamesWithEvent(searchResult.getData(), NotificationEvent.AUTHOR_CHANGED)
    if (!contractNames.isEmpty()) {
        answer.booleanData = true
        answer.textData = buildTextData(contractNames)
    }
}

private static List<String> getContractNamesWithEvent(List<ModelContractIndex> indexes, NotificationEvent event) {
    return indexes.stream()
            .map({ index -> index.getSource() })
            .filter({ modelContractRef -> modelContractRef != null })
            .map({ modelContractRef -> EntityStorage.get().resolve(modelContractRef) })
            .filter({ modelContractEtc -> modelContractEtc != null })
            .map({ modelContractEtc -> modelContractEtc.getEntity() })
            .filter({ modelContract -> hasEvent(modelContract.getRuleSet(), event) })
            .map({ modelContract -> TextUtil.nonNullStr(modelContract.getName()) })
            .collect(Collectors.toList())
}

private static boolean hasEvent(RuleSet ruleSet, NotificationEvent event) {
    return ruleSet != null && ruleSet.getRules().stream()
            .map({ rule -> rule.getRestrictions() })
            .flatMap({ restrictions -> restrictions.stream() })
            .filter({ restriction -> restriction.getProperty() == NotificationProperties.NOTIFICATION_EVENT })
            .map({ restriction -> castToList(restriction.getValue()) })
            .anyMatch({ events -> events.contains(event) })
}

@SuppressWarnings("unchecked")
private static List<NotificationEvent> castToList(Object value) {
    try {
        return (List<NotificationEvent>) value
    } catch (Exception ignored) {
        return new ArrayList<>()
    }
}

private static String buildTextData(List<String> contractNames) {
    return "ГДЕ СМОТРЕТЬ:" +
            "\n" +
            "МОМ -> Правила договоров -> Правила -> Оповещения переписки -> Условие -> Событие 'Автор изменен'" +
            "\n" +
            "ВАЖНО:" +
            "\n" +
            "Проверьте также неактуальные правила!!!" +
            "\n" +
            "ДОГОВОРЫ:" +
            "\n" +
            String.join("\n", contractNames)
}