import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder
import com.gridnine.xtrip.common.support.model.questionnaire.AnswerIndex
import com.gridnine.xtrip.common.support.model.questionnaire.Question

def query = new SearchQuery()
query.criteria.criterions.add(SearchCriterion.eq(AnswerIndex.Property.question.name(), new EntityReference('b6662b72-66c6-4ac7-910e-cf0d2fdeade6', Question.class, null)))
query.criteria.orders.put(AnswerIndex.Property.appId.name(), SortOrder.ASC)
def file = new File('/tmp/IBECORP-6281.html')
file.append("""<html>
<head>
<style>
table, th, td {
  border: 1px solid black;
  border-collapse: collapse;
}
</style>
</head>
<body>
<table>
<tr>
<th>ID инсталляции</th>
<th>Правила</th>
</tr>""")
EntityStorage.get().search(AnswerIndex.class, query).data.each {
    def answer = EntityStorage.get().resolve(it.source).entity
    file.append("""<tr>
<td>${answer.appId}</td>
<td>${answer.textAnswer}</td>
</tr>""")
}
file.append("""</table>
</body>
</html>""")
