import com.gridnine.xtrip.common.fx.assets.FxWorkspace
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem
import com.gridnine.xtrip.common.model.BaseAsset
import com.gridnine.xtrip.common.model.asset.AssetsStorage
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.TextUtil

SearchQuery query = new SearchQuery()
query.preferredProperties.add(BaseAsset.Property.uid.name())
List<String> data = []
AssetsStorage.get().search(FxWorkspace.class, query).data.each { fxw ->
    fxw = AssetsStorage.get().load(FxWorkspace.class, fxw.uid)
    process(fxw.items, fxw.owner, data)
}

if (!data.isEmpty()) {
    answer.booleanData = true
    answer.textData = data.join("\r\n")
}

static void process(List<FxWorkspaceItem> items, String path, List<String> data) {
    items.each { fxwi ->
        if (fxwi.toolId == 'index-list-nav-tool' && fxwi.parameters) {
            try {
                def toolData = new XmlSlurper().parse(new ByteArrayInputStream(fxwi.parameters))
                if (toolData.indexType.text() == 'com.gridnine.xtrip.common.model.profile.OrganizationIndex') {
                    if (toolData.restrictionGroups.item.find { hasManagersInRestrictionGroup(it) }) {
                        data.add("${path}/${fxwi.name} (restrictionGroups)")
                    }
                    if (toolData.columns.item.find { it.propertyId.text() == 'managers' }) {
                        data.add("${path}/${fxwi.name} (columns)")
                    }
                    if (toolData.filters.item.find { it.propertyId.text() == 'managers' }) {
                        data.add("${path}/${fxwi.name} (filters)")
                    }
                }
            } catch (Exception ex) {
                data.add("${path}/${fxwi.name} (exception)")
                data.add("(debug) ${new String(fxwi.parameters)}")
                data.add("(debug) ${TextUtil.getExceptionStackTrace(ex)}")
            }
        }
        process(fxwi.subItems, "${path}/${fxwi.name}", data)
    }
}

static boolean hasManagersInRestrictionGroup(def group) {
    switch (group.value.'@class') {
        case 'java.util.ArrayList':
        case 'java.util.Collections$SingletonList':
            return group.value.item.find { hasManagersInRestrictionGroup(it) }
        case 'com.gridnine.xtrip.common.restriction.RestrictionValue':
            return group.value.propertyId.text() == 'com.gridnine.xtrip.common.model.profile.OrganizationIndex.managers'
        default:
            throw new Exception("unexpected group value class ${group.value.'@class'}")
    }
}
