package com.gridnine.xtrip.server.ibecorp.tasks.groovy.uts848

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings
import com.gridnine.xtrip.common.model.mail.MailDocument
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex
import com.gridnine.xtrip.common.model.system.DocumentType
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder
import com.gridnine.xtrip.common.util.TextUtil
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper
import com.gridnine.xtrip.server.model.tasks.standard.ExecuteGroovyScriptTask
import groovy.transform.Field
import org.apache.commons.lang.time.FastDateFormat

import java.text.SimpleDateFormat

@Field String fileSuffix = FastDateFormat.getInstance("yyyy.MM.dd_HH.mm").format(new Date());
@Field FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy HH:mm");

@Field Date startDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse("2024-01-22 10:00");
@Field Date endDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse("2024-01-22 18:40");


@Field EntityReference ownerRef = null;
//@Field EntityReference ownerRef = new EntityReference<>("7477084e-3ca6-40fb-aa5e-baab34a798b4", BookingFile.class, null);

@Field boolean onlyLook = true;

if (onlyLook) {
    fileMessage("Режим 'Только просмотр' ");
    fileMessage("");
}
doJob();



void doJob() {

    EntityContainer<SMNotificationsSettings> mailSettings = EntityStorage.get().resolve(
            new EntityReference<>("default_site_notifications_settings_uid", SMNotificationsSettings.class, null))
    if (mailSettings == null) {
        fileMessage("Не найдены почтовые настройки");
        return;
    }

    ExecuteGroovyScriptTask.InputFile file = inputFile;
    if (file == null) {
        fileMessage("no file");
        return;
    }
    String uidsText = new String(file.getBody(), "utf-8");
    if (TextUtil.isBlank(uidsText)){
        fileMessage("Список уидов документов пуст");
        return;
    }
    String[] uids = uidsText.split("\n");
    fileMessage("Кол-во уидов ${uids.length}");

    SearchQuery query = new SearchQuery();
    query.getCriteria().getCriterions().add(
            SearchCriterion.eq(BasicDocumentIndex.Property.type.name(), DocumentType.MAIL_DOCUMENT));
    query.getCriteria().getCriterions().add(
            SearchCriterion.between(BasicDocumentIndex.Property.created.name(), startDate, endDate));
    query.getCriteria().getCriterions().add(
            SearchCriterion.in("containerUid", uids));
    if (ownerRef != null) {
        EntityContainer ownerCtr = EntityStorage.get().resolve(ownerRef);
        if (ownerCtr == null) {
            fileMessage("Введен некрректный uid заказа");
            return;
        }
        fileMessage("Выбран заказ ${ownerCtr.getEntity()}");
        query.getCriteria().getCriterions().add(
                SearchCriterion.eq(BasicDocumentIndex.Property.owner.name(), ownerCtr.toReference()));
    }

    query.getPreferredProperties().add("containerUid");
    query.getCriteria().getOrders().put(BasicDocumentIndex.Property.created.name(), SortOrder.ASC);

    List<BasicDocumentIndex> indices =
            EntityStorage.get().search(BasicDocumentIndex.class, query).getData();
    def current = 0
    def total = indices.size()
    def progr = 0
    int errors = 0;

    fileMessage("Найдено $total писем");

    if (indices.isEmpty()) {
        return;
    }
    if (onlyLook) {
        return;
    }

    int sended = 0;
    List<EntityReference> owners = new ArrayList<>();
    for (BasicDocumentIndex ind : indices) {
        if (isToBeStopped()) {
            fileMessage("iterator stopped")
            break;
        }
        Thread.sleep(1000*15)
        try {
            EntityContainer<MailDocument> mailDocCtr = EntityStorage.get().resolve(ind.getSource());
            MailDocument mailDoc = mailDocCtr.getEntity();

            EntityReference owner = mailDoc.getOwner();
            if (!owners.contains(owner)){
                owners.add(owner);
            }
            NotificationHelper.sendMail(mailSettings.getEntity().getMailServerParameters(), mailDoc, false);
            sended++;
        } catch (Exception ex) {
            errors++;
            fileMessage("Ошибка (${ind.name}) : ${TextUtil.getExceptionStackTrace(ex)}", false);
        }

        def progrNew = Math.round(current * 100d / total)
        if (progr != progrNew) {
            progress("${current + 1} / ${total}".toString(), (int) progrNew)
        }
        progr = progrNew
        current++
    }
    def progrNew = Math.round(current * 100d / total)
    progress("${current} / ${total}".toString(), (int) progrNew)

    fileMessage("");
    fileMessage("Возникло ошибок: ${errors}");
    fileMessage("");
    fileMessage("Отправлено писем: ${sended}");
    fileMessage("");
    fileMessage("Список владельцев отправленных писем: ${owners.toString()}", false);
}

void fileMessage(String str) {
    fileMessage(str, true)
}

void fileMessage(String str, boolean writeToConsole) {
    if (writeToConsole) {
        message(str);
    }
    new File(Environment.getTempFolder(), "uts848-${fileSuffix}.txt")
            .append("${DTF.format(new Date())}: ${str} \n");
}