import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex
import com.gridnine.xtrip.common.model.dict.CodeSystem
import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.dict.GeoLocation
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.server.storage.DictionaryStorage

Set<String> hasProducts = new HashSet<>()
Set<String> codeWillBeRemoved = new HashSet<>()
Set<String> locWillBeRemoved = new HashSet<>()

Set<String> codes = new HashSet<>(new File('/tmp/geolocs.dat').readLines())
DictionaryCache.get().getAll(GeoLocation.class).values().each { loc ->
    def code = loc.codeVariants.get(CodeSystem.HOTEL_AGGREGATOR.name())
    if (code && !codes.contains(code)) {
        def query = new SearchQuery()
        query.criteria.criterions.add(SearchCriterion.eq(MainHotelProductIndex.Property.hotelCity.name(), loc.toReference()))
        query.limit = 1
        if (EntityStorage.get().search(MainHotelProductIndex.class, query).data.size() > 0) {
            hasProducts.add(loc.code)
        } else {
            if (loc.codeVariants.size() > 1) {
                codeWillBeRemoved.add(loc.code)
                loc.codeVariants.remove(CodeSystem.HOTEL_AGGREGATOR.name())
                loc.dataSource = 'remove non-existing HA code'
                DictionaryStorage.get().save(loc)
            } else {
                locWillBeRemoved.add(loc.code)
                DictionaryStorage.get().delete(loc)
            }
        }
    }
}

message("Can't remove because there are products ${hasProducts.join(', ')}")
message("HA code will be removed from ${codeWillBeRemoved.join(', ')}")
message("GEO locations will be deleted ${locWillBeRemoved.join(', ')}")
