import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.booking.BookingFile
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.entity.misc.StorageUtil
import com.gridnine.xtrip.server.db.storage.LogicalStorage
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry
import org.slf4j.LoggerFactory

def logger = LoggerFactory.getLogger('com.gridnine.xtr12202')
def storage = Environment.getPublished(LogicalStorageRegistry.class).getStorage('hibernate')
def session = storage.sm.factory.openSession()
def sqlQuery = session.createSQLQuery("""
	SELECT uid
	FROM entitydata
	WHERE entitytype='com.gridnine.xtrip.common.model.booking.BookingFile'
	    AND lastversiondatasource='parsers-inmob:processing (ibus)'
	""".toString())
def data = sqlQuery.list()
int current = 0
int total = data.size()
int progr = 0
data.each {
    def ref = new EntityReference<BookingFile>(it, BookingFile.class, null)
    def versions = LogicalStorage.get().getEntityStorage().getVersionInfos(ref)
    def prevVersion = versions[versions.size() - 2]
    int i = 1
    while (prevVersion.dataSource == 'parsers-inmob:processing (ibus)' || prevVersion.dataSource == 'auto get coupon status') {
        prevVersion = versions[versions.size() - 2 - i]
        i++
    }
    if (prevVersion.dataSource != 'shipments:create') {
        logger.info("booking ${it} skipped as prev version is not shipments:create");
    } else {
        StorageUtil.restore(ref, prevVersion.versionNumber)
        logger.info("booking ${it} rolled back to version ${prevVersion.versionNumber}");
    }
    int progrNew = Math.round(current * 100d / total);
    if (progr != progrNew) {
        progress("${current} / ${total}", progrNew);
    }
    progr = progrNew;
    current++
}
