package com.gridnine.xtrip.server.ibecorp.tasks.groovy.ibecorp1948

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.dict.Country
import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.dict.DictionaryReference
import com.gridnine.xtrip.common.model.dict.GeoLocation
import com.gridnine.xtrip.common.util.CollectionUtil
import com.gridnine.xtrip.common.util.TextUtil
import com.gridnine.xtrip.server.storage.DictionaryStorage
import groovy.transform.Field
import org.apache.commons.lang.time.FastDateFormat

@Field String fileSuffix = FastDateFormat.getInstance("yyyy.MM.dd_HH.mm").format(new Date());
@Field FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy HH:mm");

@Field boolean onlyLook = true;

if (onlyLook) {
    fileMessage("Режим 'Только просмотр' ");
    fileMessage("");
}
doJob();


void doJob() {

    DictionaryCache dictCache = DictionaryCache.get();
    Collection<GeoLocation> locations = dictCache.getAll(GeoLocation.class).values();

    def current = 0
    def total = locations.size()
    def progr = 0

    fileMessage("Найдено $total локаций");

    int errors = 0;
    int deleted = 0;
    Map<String, List<String>> deletedGeoLocations = new HashMap<>();

    for (GeoLocation it : locations){
        if (isToBeStopped()) {
            fileMessage("iterator stopped")
            break;
        }
        try {
            DictionaryReference<Country> countryRef = it.getCountry();
            String countryCode = countryRef==null ? "ref_is_null" : "$countryRef.code ($countryRef.caption)";
            Country country = dictCache.resolveReference(countryRef);
            if (country==null){
                Collection<String> countryLocs = CollectionUtil.getOrAddList(deletedGeoLocations, countryCode);
                countryLocs.add(it.getCode());
                if (!onlyLook){
                    DictionaryStorage.get().delete(it);
                }
                deleted++;
            }
        } catch (Exception ex) {
            errors++;
            fileMessage("Ошибка (${it.code}) : ${TextUtil.getExceptionStackTrace(ex)}", false);
        }

        def progrNew = Math.round(current * 100d / total)
        if (progr != progrNew) {
            progress("${current + 1} / ${total}".toString(), (int) progrNew)
        }
        progr = progrNew
        current++
    }
    def progrNew = Math.round(current * 100d / total)
    progress("${current} / ${total}".toString(), (int) progrNew)

    fileMessage("");
    fileMessage("");
    fileMessage("Итого обработано ${current} локаций.");
    fileMessage("");
    fileMessage("Удалено ${deleted} локаций:");
    deletedGeoLocations.each {
        fileMessage("${it.key} - ${it.value.size()}: ${it.value}");
        fileMessage("");
    }
    fileMessage("");
    fileMessage("Итого возникло ${errors} ошибок");

}

void fileMessage(String str){
    fileMessage(str, true)
}

void fileMessage(String str, boolean writeToConsole){
    if (writeToConsole){
        message(str);
    }
    new File(Environment.getTempFolder(), "ibecorp1948_${fileSuffix}.txt")
            .append("${DTF.format(new Date())}: ${str} \n");
}