package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.booking.BookingFile
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.system.BaseFileDocument
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import groovy.transform.Field
import org.apache.commons.lang.time.FastDateFormat

@Field String fileSuffix = FastDateFormat.getInstance("yyyy.MM.dd_HH.mm").format(new Date());
@Field FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy HH:mm");

@Field boolean onlyLook = false;
@Field int maxCountRelatedDoc = 10;


if (onlyLook) {
    fileMessage("Режим 'Только просмотр' ");
    fileMessage("");
}
doJob();


void doJob() {
    def storage = EntityStorage.get()

    SearchQuery query = new SearchQuery();
    query.getCriteria().getCriterions()
            .add(SearchCriterion.eq(
                    MainHotelProductIndex.Property.provider.name(), HotelProvider.BRONEVIK
            ))

    List<MainHotelProductIndex> hotelProductIndexList =
            storage.search(MainHotelProductIndex.class, query).getData();

    def total = hotelProductIndexList.size()

    fileMessage("Всего найдено $total отльных продуктов");

    hotelProductIndexList.forEach({ hotelProduct ->
        EntityContainer<BookingFile> hotelProductCtr = storage.resolve(hotelProduct.source)

        SearchQuery queryProduct = new SearchQuery();
        queryProduct
                .getCriteria()
                .getCriterions()
                .add(
                        SearchCriterion.eq(
                                BasicDocumentIndex.Property.owner.name(),
                                hotelProductCtr.toReference()))

        List<BasicDocumentIndex> basicDocumentIndexList =
                storage.search(BasicDocumentIndex.class, queryProduct).getData()

        if (basicDocumentIndexList.size() > maxCountRelatedDoc) {
            fileMessage("Отельный продукт №" + hotelProduct.getBookingNumber() +
                    " Количество связанных документов " + basicDocumentIndexList.size(), true)
        }

        if (!onlyLook && basicDocumentIndexList.size() > maxCountRelatedDoc) {
            boolean wasChanged = false
            int countRemove = 0
            basicDocumentIndexList.forEach({it ->
                EntityContainer<BaseFileDocument> docCtr = storage.resolve(it.source)
                BaseFileDocument doc = docCtr.getEntity()

                if (docCtr != null) {
                    if ("Bronevik order info" == doc.getDescription() &&
                            "Bronevik online order" == doc.getName() &&
                            "XML" == doc.getContentType().toString()) {
                            storage.delete(docCtr)
                            ++ countRemove
                            wasChanged = true
                    }
                }
            })
            fileMessage("У отельного продукта №" + hotelProduct.getBookingNumber() +
                    " Было удалено " + countRemove + " связанных документов")
            if (wasChanged) {
                hotelProductCtr.getVersionInfo()setDataSource("IBECORP-3759")
                hotelProductCtr.getVersionInfo().setVersionNotes("Удаление большого количества связанных документов")
                storage.save(hotelProductCtr, true)
            }
        }
    })
}

void fileMessage(String str) {
    fileMessage(str, true)
}

void fileMessage(String str, boolean writeToConsole) {
    if (writeToConsole) {
        message(str);
    }
    new File(Environment.getTempFolder(), "IBECORP-3759${fileSuffix}.txt")
            .append("${DTF.format(new Date())}: ${str} \n");
}