package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.dict.Aircraft
import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.util.TextUtil
import com.gridnine.xtrip.common.util.XmlUtil
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper
import com.gridnine.xtrip.server.model.tasks.standard.ExecuteGroovyScriptTask
import com.gridnine.xtrip.server.storage.DictionaryStorage
import groovy.transform.Field
import org.apache.commons.lang.time.FastDateFormat
import org.w3c.dom.Element

@Field String fileSuffix = FastDateFormat.getInstance("yyyy.MM.dd_HH.mm").format(new Date());
@Field FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy HH:mm");
@Field File tempFolder = Environment.getTempFolder()

fileMessage("path log:" + tempFolder.toString())

doJob()

void doJob() {

    ExecuteGroovyScriptTask.InputFile file = inputFile;
    if (file == null) {
        fileMessage("no file");
        return;
    }
    fileMessage("file received ");

    Element root = DocumentBuilderHelper.parse(new ByteArrayInputStream(file.getBody())).getDocumentElement();
    Element[] elements = XmlUtil.getElements(root, "object")
    fileMessage("elements: " + elements.size());

    fileMessage("create Aircraft");
    List<Aircraft> aircraftXmlList = new ArrayList<>()
    for (Element elm : elements) {
        if (isToBeStopped()) {
            fileMessage("iterator stopped")
            break;
        }
        Aircraft aircraft = new Aircraft()
        aircraft.fromXML(elm)
        aircraftXmlList.add(aircraft)
    }
    fileMessage("created " + aircraftXmlList.size() + " Aircraft");

    Collection<Aircraft> aircraftDictList = DictionaryCache.get().getAll(Aircraft.class).values();
    fileMessage("started update dictionary Aircraft")

    Iterator<Aircraft> iterator = aircraftXmlList.iterator();
    while (iterator.hasNext()) {
        Aircraft aircraftXml = iterator.next();
        if (!isSuccessAddTranslations(aircraftXml, aircraftDictList)) {
            aircraftXml.setDataSource('IBECORP-5337')
            DictionaryStorage.get().save(aircraftXml);
            fileMessage("add Aircraft code " + aircraftXml.getCode(), false)
        }
    }

    fileMessage("Update Done")

}

boolean isSuccessAddTranslations(final Aircraft aircraftXml,
                                 final Collection<Aircraft> aircraftDictList) throws Exception {
    String codeXml = aircraftXml.getCode();
    if (codeXml != null) {
        for (Aircraft aircraftDict : aircraftDictList) {
            if (isToBeStopped()) {
                fileMessage("iterator stopped")
                break;
            }
            String codeDict = aircraftDict.getCode();
            if (codeDict != null) {
                boolean save = false;
                if (codeXml.equals(codeDict)) {
                    Map<Locale, String> translations = aircraftDict.getTranslations();
                    for (Locale locale : aircraftXml.getTranslations().keySet()) {
                        if (TextUtil.isBlank(translations.get(locale))) {
                            translations.put(locale, aircraftXml.getTranslations().get(locale));
                            save = true
                        }
                    }
                    if (save) {
                        aircraftDict.setDataSource('IBECORP-5337')
                        DictionaryStorage.get().save(aircraftDict);
                        fileMessage("update Aircraft code " + aircraftDict.getCode(), false)
                    }
                    return true;
                }
            }
        }
    }
    return false;
}

void fileMessage(String str) {
    fileMessage(str, true)
}

void fileMessage(String str, boolean writeToConsole) {
    if (writeToConsole) {
        message(str);
    }
    new File(tempFolder, "IBECORP-5337${fileSuffix}.txt")
            .append("${DTF.format(new Date())}: ${str} \n");
}
