package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.booking.BaseProduct
import com.gridnine.xtrip.common.model.booking.BookingFile
import com.gridnine.xtrip.common.model.booking.Reservation
import com.gridnine.xtrip.common.model.booking.statistics.ProductBillingDataChangeDataSource
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper
import com.gridnine.xtrip.common.model.helpers.BookingHelper
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper
import com.gridnine.xtrip.common.model.booking.CommonProductIndex
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import org.apache.commons.lang.time.FastDateFormat

import java.util.stream.Collectors

FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy")

StringBuilder builder = new StringBuilder()

Calendar calendar = Calendar.getInstance()
calendar.set(2025, Calendar.APRIL, 1, 0, 0, 0)
Date date = calendar.getTime()

SearchQuery searchQuery = new SearchQuery()
searchQuery.getCriteria().getCriterions().add(SearchCriterion.and(
        SearchCriterion.ge(CommonProductIndex.Property.issueDate.name(), date),
        SearchCriterion.eq(CommonProductIndex.Property.statisticsGdsName.name(), null),
        SearchCriterion.or(
                SearchCriterion.isEmpty(CommonProductIndex.Property.changeDataSources.name()),
                SearchCriterion.contains(CommonProductIndex.Property.changeDataSources.name(), ProductBillingDataChangeDataSource.ONLINE),
                SearchCriterion.contains(CommonProductIndex.Property.changeDataSources.name(), ProductBillingDataChangeDataSource.EXCHANGE_FILE))))

searchQuery.getPreferredProperties().add("navigationKey")

List<CommonProductIndex> indexList = EntityStorage.get().search(CommonProductIndex.class, searchQuery).getData()

builder.append("Найдено $indexList.size продуктов за период с ${DTF.format(date)}\nСписок продуктов, созданных/измененных не клиентом, у которых в бронировании не заполнена система бронирования (транзакции): ")

for (CommonProductIndex index : indexList) {
    EntityContainer<BookingFile> bfCtr = EntityStorage.get().resolve(index.getSource())
    if (EntityStorageHelper.isEmpty(bfCtr)) {
        continue
    }
    BookingFile bookingFile = bfCtr.getEntity()

    for (Reservation reservation : bookingFile.getReservations()) {
        if (reservation.getGdsNameInfo().getStatisticsGdsName() == null) {
            for (BaseProduct product : reservation.getProducts()) {
                if (product.getBillingDataChangeEntries().isEmpty() ||
                        product.getBillingDataChangeEntries().stream().anyMatch({ e ->
                            e.getSource() != ProductBillingDataChangeDataSource.CLIENT})) {
                    builder.append("\n" + "Заказ: " + bookingFile.getNumber())
                    builder.append(" Дата создания заказа: " + (bookingFile.getCreateDate() != null ? DTF.format(bookingFile.getCreateDate()) : null))
                    builder.append(" Бронирование: " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator(reservation))
                    builder.append(" Продукт: " + BookingHelper.generateShortProductName(product))
                    builder.append(" Источники изменения транзакций: " + String.join(", ", product.getBillingDataChangeEntries().stream()
                        .map({e -> e.getSource()}).filter({s -> s != null})
                        .map({s -> s.toString()}).collect(Collectors.toSet())))
                }
            }
        }
    }
}

answer.booleanData = indexList.size() != 0
answer.textData = builder.toString()