package com.gridnine.xtrip.server.ibecorp.tasks.groovy.psk11027

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.Xeption
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.helpers.ProfileHelper
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper
import com.gridnine.xtrip.common.model.profile.*
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.MiscUtil
import com.gridnine.xtrip.common.util.TextUtil
import groovy.transform.Field
import org.apache.commons.lang.time.FastDateFormat

@Field String fileSuffix = FastDateFormat.getInstance("yyyy.MM.dd_HH.mm").format(new Date());
@Field FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy HH:mm");

@Field boolean onlyLook = true;
@Field String holdingCode = "";

if (onlyLook) {
    fileMessage("Режим 'Только просмотр' ");
    fileMessage("");
}
doJob();


void doJob() {

    List<EntityReference<Organization>> clients = findClients();
    fileMessage("Найдено ${clients.size()} клиентов: ${clients}");
    if (clients.isEmpty()){
        return;
    }

    SearchQuery query = new SearchQuery();
    query.getCriteria().getCriterions().add(
            SearchCriterion.contains(PersonIndex.Property.types.name(), PersonType.PASSENGER));
    List<String> clientUids = clients.collect {it.getUid()};
    query.getCriteria().getCriterions().add(
            SearchQueryHelper.buildOrContainsStringCriterion(PersonIndex.Property.employmentsUids.name(), clientUids));

    query.getPreferredProperties().add(PersonIndex.Property.name.name());

    List<PersonIndex> indexes = EntityStorage.get().search(PersonIndex.class, query).getData();

    def current = 0
    def total = indexes.size()
    def progr = 0

    fileMessage("Найдено $total пассажиров");

    int withUdids = 0;
    int updated = 0;
    int errors = 0;
    List<EntityReference<Person>> updatedPersons = new ArrayList<>();

    for (PersonIndex idx : indexes){
        if (isToBeStopped()) {
            fileMessage("iterator stopped")
            break;
        }
        try {
            EntityContainer<Person> personCtr = EntityStorage.get().resolve(idx.getSource());
            if (!personCtr.getEntity().getCostCodes().isEmpty()){
                withUdids++;
                if (needUpdate(personCtr.getEntity())){
                    if (!onlyLook){
                        update(personCtr.getEntity());
                        personCtr.getVersionInfo().setDataSource("PSK-11027");
                        personCtr.getVersionInfo().setVersionNotes("удаление дубликатов UDID");
                        EntityStorage.get().save(personCtr, true);
                    }
                    updated ++;
                    updatedPersons.add(personCtr.toReference());
                }
            }
        } catch (Exception ex) {
            errors++;
            fileMessage("Ошибка (${idx.name}) : ${TextUtil.getExceptionStackTrace(ex)}", false);
        }

        def progrNew = Math.round(current * 100d / total)
        if (progr != progrNew) {
            progress("${current + 1} / ${total}".toString(), (int) progrNew)
        }
        progr = progrNew
        current++
    }
    def progrNew = Math.round(current * 100d / total)
    progress("${current} / ${total}".toString(), (int) progrNew)

    fileMessage("");
    fileMessage("");
    fileMessage("Итого обработано пассажиров: ${current}");
    fileMessage("Из них с UDID: ${withUdids}");
    fileMessage("");
    fileMessage("Изменено пассажиров: ${updated}");
    fileMessage("" + updatedPersons.collect {it.caption + "(" + it.uid + ")"}, false);
    fileMessage("");
    fileMessage("Возникло ошибок: ${errors}");

}

List<EntityReference<Organization>> findClients(){
    if (TextUtil.isBlank(holdingCode)){
        throw Xeption.forEndUser("Не указан код холдинга");
    }
    EntityReference<Holding> holdingRef = EntityStorage.get().findReference(HoldingIndex.class, HoldingIndex.Property.code.name(), holdingCode);
    if (holdingRef == null) {
        throw Xeption.forEndUser("Не найден холдинг с кодом ${holdingCode}");
    }
    fileMessage("Поиск клиентов холдинга ${holdingCode} - ${holdingRef.caption}");
    return ProfileHelper.getHoldingOrganizations(Collections.singleton(holdingRef));
}

boolean needUpdate(Person person){
    return update(person, true);
}

void update(Person person){
    update(person, false)
}

boolean update(Person person, boolean onlyCheck){
    boolean result = false;
    List<PersonCostCode> keep = new ArrayList<>();
    for (PersonCostCode cc : person.getCostCodes()){
        PersonCostCode same = keep.find {isSame(it, cc)}
        if (same==null){
            keep.add(cc);
        }
    }
    if (keep.size()<person.getCostCodes().size()){
        result = true;
        if (!onlyCheck){
            person.getCostCodes().removeAll {!keep.contains(it)}
        }
    }
    return result;
}

boolean isSame(PersonCostCode cc1, PersonCostCode cc2){
    if (!MiscUtil.equals(cc1.getOrganization(), cc2.getOrganization())){
        return false;
    }
    if (MiscUtil.equals(cc1.getCostCodeProperties(), cc2.getCostCodeProperties())){
        return true;
    }
    if (cc1.getCostCodeProperties()==null || cc2.getCostCodeProperties()==null){
        return false;
    }
    if (!MiscUtil.equals(cc1.getCostCodeProperties().getCategory(), cc2.getCostCodeProperties().getCategory())){
        return false;
    }
    return true;
}

void fileMessage(String str){
    fileMessage(str, true)
}

void fileMessage(String str, boolean writeToConsole){
    if (writeToConsole){
        message(str);
    }
    new File(Environment.getTempFolder(), "psk11027_${fileSuffix}.txt")
            .append("${DTF.format(new Date())}: ${str} \n");
}