package com.gridnine.xtrip.server.ibecorp.tasks.groovy.psk11101

import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.PersonIndex
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

doJob();

void doJob() {

    SearchQuery query = new SearchQuery();
    query.getCriteria().getCriterions().add(
            SearchCriterion.isNotEmpty(PersonIndex.Property.code.name()));
    query.getPreferredProperties().add(PersonIndex.Property.code.name());
    List<PersonIndex> indexes = EntityStorage.get().search(PersonIndex.class, query).getData();

    List<String> dublicates = indexes.countBy { it.code }.grep { it.value > 1 }.collect { it.key }
    message("Найдено ${dublicates.size()} дубликатов :\n${dublicates}");

}