package com.gridnine.xtrip.server.ibecorp.tasks.groovy.tuibt111

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.PersonPassportIndex
import com.gridnine.xtrip.common.model.dict.PassportType
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.Passport
import com.gridnine.xtrip.common.model.profile.Person
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.TextUtil
import groovy.transform.Field
import org.apache.commons.lang.time.FastDateFormat

@Field String fileSuffix = FastDateFormat.getInstance("yyyy.MM.dd_HH.mm").format(new Date());
@Field FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy HH:mm");

@Field boolean onlyLook = true;

if (onlyLook) {
    fileMessage("Режим 'Только просмотр' ");
    fileMessage("");
}
doJob();


void doJob() {

    SearchQuery query = new SearchQuery();
    query.getCriteria().getCriterions().add(
        SearchCriterion.or(
            SearchCriterion.like(PersonPassportIndex.Property.passportNumber.name(), "% %"),
            SearchCriterion.and(
                SearchCriterion.eq(PersonPassportIndex.Property.passportType.name(), PassportType.INTERNAL),
                SearchCriterion.like(PersonPassportIndex.Property.passportNumber.name(), "_________") // len = 9
            )
        ));
    query.getPreferredProperties().add(PersonPassportIndex.Property.passportNumber.name());
    query.getPreferredProperties().add(PersonPassportIndex.Property.passportType.name());

    List<PersonPassportIndex> indexes = EntityStorage.get().search(PersonPassportIndex.class, query).getData();

    def current = 0
    def total = indexes.size()
    def progr = 0

    fileMessage("Найдено $total паспортов");

    int pspUpdated = 0;
    int personUpdated = 0;
    int errors = 0;
    List<EntityReference<Person>> updatedPersons = new ArrayList<>();

    for (PersonPassportIndex idx : indexes){
        if (isToBeStopped()) {
            fileMessage("iterator stopped")
            break;
        }
        try {
            if (!updatedPersons.contains(idx.getSource())){
                EntityContainer<Person> personCtr = EntityStorage.get().resolve(idx.getSource());
                int psps = needUpdate(personCtr.getEntity())
                if (psps>0){
                    if (!onlyLook){
                        update(personCtr.getEntity());
                        personCtr.getVersionInfo().setDataSource("TUIBT-111");
                        personCtr.getVersionInfo().setVersionNotes("корректировка номера и типа паспорта");
                        EntityStorage.get().save(personCtr, true);
                    }
                    pspUpdated += psps;
                    personUpdated ++;
                    updatedPersons.add(personCtr.toReference());
                }
            }
        } catch (Exception ex) {
            errors++;
            fileMessage("Ошибка (${it.code}) : ${TextUtil.getExceptionStackTrace(ex)}", false);
        }

        def progrNew = Math.round(current * 100d / total)
        if (progr != progrNew) {
            progress("${current + 1} / ${total}".toString(), (int) progrNew)
        }
        progr = progrNew
        current++
    }
    def progrNew = Math.round(current * 100d / total)
    progress("${current} / ${total}".toString(), (int) progrNew)

    fileMessage("");
    fileMessage("");
    fileMessage("Итого обработано ${current} индексов.");
    fileMessage("");
    fileMessage("Изменено ${pspUpdated} паспортов");
    fileMessage("Изменено ${personUpdated} персон");
    fileMessage("" + updatedPersons.collect {it.caption + "(" + it.uid + ")"}, false);
    fileMessage("");
    fileMessage("Возникло ${errors} ошибок");

}

int needUpdate(Person person){
    return update(person, true);
}

void update(Person person){
    update(person, false)
}

int update(Person person, boolean onlyCheck){
    int result = 0;
    for (Passport psp : person.getPassports()){
        if (TextUtil.isBlank(psp.getNumber())){
            continue;
        }
        boolean pspUpdated = false;
        if (psp.getNumber().contains(" ")){
            if (!onlyCheck){
                psp.setNumber(psp.getNumber().replaceAll(" ", ""));
            }
            pspUpdated = true;
        }
        if (psp.getNumber().length()==9 && psp.getType()== PassportType.INTERNAL){
            if (!onlyCheck){
                psp.setType(PassportType.FOREIGN);
            }
            pspUpdated = true;
        }
        if (pspUpdated){
            result++;
        }
    }
    return result;
}

void fileMessage(String str){
    fileMessage(str, true)
}

void fileMessage(String str, boolean writeToConsole){
    if (writeToConsole){
        message(str);
    }
    new File(Environment.getTempFolder(), "tuibt111_${fileSuffix}.txt")
            .append("${DTF.format(new Date())}: ${str} \n");
}