package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.profile.OrganizationType
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.TextUtil
import groovy.transform.Field
import org.apache.commons.lang.time.FastDateFormat

@Field String fileSuffix = FastDateFormat.getInstance("yyyy.MM.dd_HH.mm").format(new Date())
@Field FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy HH:mm")

@Field boolean onlyLook = true


if (onlyLook) {
    fileMessage("Режим 'Только просмотр' ")
}
doJob()

void doJob() {

    SearchQuery query = new SearchQuery()
    query.getCriteria()
            .getCriterions()
            .add(SearchCriterion.and(
                    SearchCriterion.contains(
                            OrganizationIndex.Property.types.name(), OrganizationType.CORPORATE_CLIENT.name()),
                    SearchCriterion.isNotEmpty(OrganizationIndex.Property.keyContacts.name())
            ))

    query.getPreferredProperties().add("containerUid")

    List<OrganizationIndex> organizationIndices =
            EntityStorage.get().search(OrganizationIndex.class, query).getData()

    def current = 0
    def total = organizationIndices.size()
    def progr = 0
    int errors = 0

    fileMessage("Найдено $total клиентских организации")

    List<String> changedClient = new ArrayList<String>()
    List<String> activeClient = new ArrayList<String>()

    for (OrganizationIndex ind : organizationIndices) {
        if (isToBeStopped()) {
            fileMessage("iterator stopped")
            break
        }

        try {
            boolean isSave = false
            EntityContainer<Organization> org = EntityStorage.get().resolve(ind.getSource())
            if (EntityStorageHelper.nonEmpty(org)) {
                for (ProfileKeyContactPerson profileKeyContactPerson : org.getEntity().getKeyContacts()) {
                    if (!profileKeyContactPerson.isAuthorizer() && profileKeyContactPerson.getPerson() != null) {
                        if (!onlyLook) {
                            profileKeyContactPerson.setAuthorizer(true)
                            isSave = true
                        }
                        changedClient.add("{" + org.toReference().getUid() + " : " + org.getEntity().getKeyContacts().size() + "}")
                    } else {
                        activeClient.add("{" + org.toReference().getUid() + "}")
                    }
                }
            }
            if (isSave) {
                if (!onlyLook) {
                    org.getVersionInfo().setDataSource("XTR-12036")
                    org.getVersionInfo().setVersionNotes("Key contactcs - parametr authorizator make YES by defult")
                    EntityStorage.get().save(org, true)
                }
            }
        } catch (Exception ex) {
            errors++
            fileMessage("Ошибка (${ind.name}) : ${TextUtil.getExceptionStackTrace(ex)}", false)
        }

        def progrNew = Math.round(current * 100d / total)
        if (progr != progrNew) {
            progress("${current + 1} / ${total}".toString(), (int) progrNew)
        }
        progr = progrNew
        current++
    }
    def progrNew = Math.round(current * 100d / total)
    progress("${current} / ${total}".toString(), (int) progrNew)

    fileMessage("Активированы \"Ключевые контактные лица\": ${changedClient.size()}")
    fileMessage("Активные \"Ключевые контактные лица\": ${activeClient.size()}")
    fileMessage("Возникло ошибок: ${errors}")
    fileMessage("Список измененных клиентов : Код - ${changedClient.toString()}", false)
}

void fileMessage(String str) {
    fileMessage(str, true)
}

void fileMessage(String str, boolean writeToConsole) {
    if (writeToConsole) {
        message(str)
    }
    new File(Environment.getTempFolder(), "xtr12036${fileSuffix}.txt")
            .append("${DTF.format(new Date())}: ${str} \n")
}