package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper
import com.gridnine.xtrip.common.model.profile.Passport
import com.gridnine.xtrip.common.model.profile.Person
import com.gridnine.xtrip.common.model.profile.PersonIndex
import com.gridnine.xtrip.common.model.profile.PersonType
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.CollectionUtil


StringBuilder builder = new StringBuilder();

int total = 0;
int noPassport = 0;


SearchQuery searchQuery = new SearchQuery();
searchQuery.getCriteria().getCriterions().add(SearchCriterion.and(
        SearchCriterion.eq(PersonIndex.Property.disabled.name(), Boolean.FALSE),
        SearchCriterion.contains(PersonIndex.Property.types.name(), PersonType.PASSENGER)));
searchQuery.getPreferredProperties().addAll(Arrays.asList(
        PersonIndex.Property.dataSource.name()
));

List<PersonIndex> personIndexList = EntityStorage.get().search(PersonIndex.class, searchQuery).getData();

builder.append("Найдено $personIndexList.size пассажиров\nСписок пассажиров без выставленного типа документов пасспорта: ");

for (PersonIndex personIndex : personIndexList) {
    EntityContainer<Person> personCtr = EntityStorage.get().resolve(personIndex.getSource());
    if (EntityStorageHelper.isEmpty(personCtr)) {
        continue;
    }
    Person person = personCtr.getEntity();
    List<Passport> passports = person.getPassports();

    if (CollectionUtil.isEmpty(passports)) {
        noPassport++;
        continue;
    }

    boolean hasEmptyTypeDoc = passports
            .stream()
            .anyMatch({ r -> r.getType() == null });

    if (!hasEmptyTypeDoc) {
        continue;
    }

    builder.append("\n" + person.getFirstName());
    builder.append(" " + person.getLastName());
    total++;
}

answer.booleanData = !(builder.length() == 0)
builder.append("\nКоличество пассажирова без документов: $noPassport");
builder.append("\nКоличество документов без типа: $total");
answer.textData = builder.toString()