<%@ page
        language="java"
        contentType="text/html; charset=utf-8"
        import="com.gridnine.xtrip.common.model.ibecorp.xreports.ReportReference"
        import="com.gridnine.xtrip.server.ibecorp.helpers.XreportsIntegrationHelper"
%>
<%@ page import="com.gridnine.xtrip.common.util.IoUtil" %>
<%@ page import="java.io.ByteArrayInputStream" %>
<%@ page import="com.gridnine.xtrip.common.util.Base64" %>
<%@ page import="java.io.OutputStream" %>
<%
    if (request.getParameter("getReport") != null) {
        String reportUid = request.getParameter("report");
        String shipmentNumber = request.getParameter("shipment");
        XreportsIntegrationHelper.ExportedReport report = XreportsIntegrationHelper.getShipmentRegistry(reportUid, shipmentNumber);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition",
                "attachment; filename="+report.getFileName());
        OutputStream os = response.getOutputStream();
        try {
            IoUtil.copyStream(new ByteArrayInputStream(report.getContent()), os, 256);
            os.flush();
        } finally {
            os.close();
        }
        return;
    }
%>
<html>
<head>
    <title>Тестирование интеграции с отчетным приложением</title>
</head>
<body>

<form action="xreports.jsp" method="post">
    <fieldset>
        <legend>Отчет</legend>
        <p>
            <label for="report">Отчет:</label>
            <select id="report" name="report">
                <% for (ReportReference reportReference : XreportsIntegrationHelper.getAllRegistries()) { %>
                <option value="<%= reportReference.getUid() %>"><%= reportReference.getTitle() %>
                </option>
                <% } %>
            </select>
        </p>
        <p>
            <label for="report">Реализация:</label>
            <input name="shipment" type="text">
        </p>
        <p>
            <input type="submit" name="getReport" value="Отчет"/>
        </p>
    </fieldset>
</form>
</body>
</html>