/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ukraine.docgen;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalNameFormat;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.server.ibecorp.ukraine.docgen.InvoiceFacturaJRDocumentRender;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperReport;

public class PaymentReceiptJRDocumentRender {
    private static final String KEY_AGENCY_NAME = "AGENCY_NAME";
    private static final String KEY_AGENCY_OKPO = "AGENCY_OKPO";
    private static final String KEY_AGENCY_BANK_SETTLEMENT_ACCOUNT = "AGENCY_BANK_SETTLEMENT_ACCOUNT";
    private static final String KEY_AGENCY_BANK_BIC = "AGENCY_BANK_BIC";
    private static final String KEY_AGENCY_BANK_NAME = "AGENCY_BANK_NAME";
    private static final String KEY_AGENCY_BANK_CITY = "AGENCY_BANK_CITY";
    private static final String KEY_CLIENT_NAME = "CLIENT_NAME";
    private static final String KEY_PAYMENT_INVOICE_NUMBER = "PAYMENT_INVOICE_NUMBER";
    private static final String KEY_PAYMENT_INVOICE_DATE = "PAYMENT_INVOICE_DATE";
    private static final String KEY_PAYMENT_AMOUNT = "PAYMENT_AMOUNT";

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFileContainer, Reservation reservation, EntityContainer<TemplateDocument> templateContainer, InvoiceFacturaJRDocumentRender.DocumentData invoiceFacturaData, Locale locale) throws Exception {
        locale = new Locale("uk", "UA");
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        TemplateDocument templateDocument = (TemplateDocument)templateContainer.getEntity();
        if (templateDocument.getContent() == null) {
            throw Xeption.forAdmin((String)"\u0423 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u0448\u0430\u0431\u043b\u043e\u043d'", (Object[])new Object[]{templateDocument.getTitle()});
        }
        JasperReport jasperReport = JasperUtil.getReport((byte[])templateDocument.getContent());
        Map<String, Object> parameters = this.getParameters(bookingFileContainer, reservation, locale, messages);
        if (parameters == null) {
            throw new Exception("unable to create parameters");
        }
        parameters.put(KEY_PAYMENT_INVOICE_NUMBER, invoiceFacturaData.getNumber());
        parameters.put(KEY_PAYMENT_INVOICE_DATE, invoiceFacturaData.getDate());
        JRDataSource dataSource = this.getDataSource(bookingFileContainer, reservation, jasperReport, locale, messages);
        if (dataSource == null) {
            throw new Exception("unable to create data source");
        }
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource, null);
        if (content == null) {
            throw new Exception("unable to fill document");
        }
        if ((content = JasperUtil.convertToPdf((byte[])content)) == null) {
            throw new Exception("unable to convert document to pdf");
        }
        Date date = new Date();
        FilledTemplateDocument filledTemplateDocument = new FilledTemplateDocument();
        filledTemplateDocument.setTitle(String.format("\u041a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u044f \u0434\u043b\u044f \u043e\u043f\u043b\u0430\u0442\u044b \u043a \u0441\u0447\u0435\u0442\u0443-\u0444\u0430\u043a\u0442\u0443\u0440\u0435 %s", invoiceFacturaData.getNumber()));
        filledTemplateDocument.setName("payment-receipt.pdf");
        filledTemplateDocument.setType(DocumentType.RECEIPT);
        filledTemplateDocument.setContentType(ContentType.PDF);
        filledTemplateDocument.setContent(content);
        filledTemplateDocument.setCreated(date);
        filledTemplateDocument.setNavigationKey(bookingFileContainer.getUid());
        filledTemplateDocument.setOwner(bookingFileContainer.toReference());
        filledTemplateDocument.setCheckSum(MiscUtil.getCheckSum((byte[])filledTemplateDocument.getContent()));
        filledTemplateDocument.setTemplate(templateContainer.toReference());
        filledTemplateDocument.getMessages().addAll(messages);
        return filledTemplateDocument;
    }

    protected Map<String, Object> getParameters(EntityContainer<BookingFile> bookingFileContainer, Reservation reservation, Locale locale, Set<Message> messages) {
        BankAccount bankAccount;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        EntityContainer agencyContainer = EntityStorage.get().resolve(bookingFile.getAgency());
        if (agencyContainer == null) {
            this.addMessage(messages, "\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        Organization agency = (Organization)agencyContainer.getEntity();
        Customer customer = bookingFile.getCustomer();
        if (customer == null) {
            this.addMessage(messages, "\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        parameters.put("REPORT_LOCALE", locale);
        parameters.put(KEY_AGENCY_NAME, ProfileHelper.getFullName((String)agency.getCode(), (L10nString)agency.getShortName(), (L10nString)agency.getFullName(), (DictionaryReference)agency.getLegalForm(), (Locale)locale, (boolean)false));
        parameters.put(KEY_AGENCY_OKPO, agency.getOkpoCode());
        BankAccount bankAccount2 = bankAccount = agency.getBankAccounts().size() > 0 ? (BankAccount)agency.getBankAccounts().get(0) : null;
        if (bankAccount != null) {
            parameters.put(KEY_AGENCY_BANK_SETTLEMENT_ACCOUNT, bankAccount.getSettlementAccount());
            parameters.put(KEY_AGENCY_BANK_BIC, bankAccount.getBik());
            parameters.put(KEY_AGENCY_BANK_NAME, bankAccount.getBankName());
            if (bankAccount.getCity() != null) {
                parameters.put(KEY_AGENCY_BANK_CITY, bankAccount.getCity().toString(locale));
            }
        }
        parameters.put(KEY_CLIENT_NAME, this.buildNameString((PersonalName)customer.getPassport(), "L F M", locale));
        BigDecimal amount = this.calculateTotalAmount(reservation);
        parameters.put(KEY_PAYMENT_AMOUNT, amount);
        return parameters;
    }

    private String buildNameString(PersonalName personalName, String pattern, Locale locale) {
        if (personalName == null) {
            return null;
        }
        PersonalNameFormat format = new PersonalNameFormat(pattern);
        return format.format(personalName);
    }

    private BigDecimal calculateTotalAmount(Reservation reservation) {
        BigDecimal totalAmount = null;
        for (BaseProduct baseProduct : reservation.getProducts()) {
            BigDecimal commissionsEquivalentValue;
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            BigDecimal totalEquivalentFare = AirProductHelper.calculateTotalEquivalentFare((Product)product);
            if (totalEquivalentFare != null) {
                BigDecimal bigDecimal = totalAmount = totalAmount != null ? totalAmount.add(totalEquivalentFare) : totalEquivalentFare;
            }
            if ((commissionsEquivalentValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null))) == null) continue;
            totalAmount = totalAmount != null ? totalAmount.add(commissionsEquivalentValue) : commissionsEquivalentValue;
        }
        return totalAmount;
    }

    protected JRDataSource getDataSource(EntityContainer<BookingFile> bookingFileContainer, Reservation reservation, JasperReport jasperReport, Locale locale, Set<Message> messages) {
        return new JREmptyDataSource();
    }

    private void addMessage(Set<Message> messages, String text, String details, MessageType type, Object ... parameters) {
        Message message = new Message();
        message.setType(type);
        message.setMessage(L10nResourcesManager.createL10nMessage((String)text, (Object[])parameters));
        message.setDetails(details);
        if (!messages.contains(message)) {
            messages.add(message);
        }
    }
}

