/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jaxws;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@Deprecated
public class InvocationContext {
    private static final ThreadLocal<InvocationContext> INSTANCE = new ThreadLocal<InvocationContext>(){

        @Override
        protected InvocationContext initialValue() {
            return new InvocationContext();
        }
    };
    private final List<TransactionWrapper> transactionWrappers = new ArrayList<TransactionWrapper>();
    private static final Logger log = LoggerFactory.getLogger(InvocationContext.class);
    private boolean active;

    public static InvocationContext get() {
        return INSTANCE.get();
    }

    public boolean isActive() {
        return this.active;
    }

    public void begin() {
        this.transactionWrappers.clear();
        this.active = true;
    }

    void addTransaction(TransactionWrapper transactionWrapper) {
        if (this.active) {
            this.transactionWrappers.add(transactionWrapper);
        } else {
            log.warn("addTransaction() ignored because of non-active state, maybe you forgot to wrap your subroute with com.gridnine.xtrip.server.jaxws.LoggingAdvice ?");
        }
    }

    public List<TransactionWrapper> getTransactions() {
        return this.transactionWrappers;
    }

    public Document buildDocument() throws Exception {
        org.w3c.dom.Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("ws-transactions");
        doc.appendChild(root);
        List transactions = this.transactionWrappers.stream().map(tw -> ((TransactionWrapper)tw).transaction).collect(Collectors.toList());
        for (Element transaction : transactions) {
            root.appendChild(doc.importNode(transaction, true));
        }
        Document document = new Document();
        document.setContent(XUtil.toString((org.w3c.dom.Document)doc).getBytes());
        document.setCheckSum(DigestUtils.md5Hex((byte[])document.getContent()));
        document.setContentType(ContentType.XML);
        document.setCreated(new Date());
        return document;
    }

    public void end() {
        this.transactionWrappers.clear();
        this.active = false;
    }

    public static class TransactionWrapper {
        private Element transaction;
        private Date startingTime;

        public TransactionWrapper(Element transaction, Date startingTime) {
            this.transaction = transaction;
            this.startingTime = startingTime;
        }

        public Date getStartingTime() {
            return this.startingTime;
        }

        public Element getTransaction() {
            return this.transaction;
        }
    }
}

