/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jaxws;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class JaxWsHelper {
    private static final DatatypeFactory DATATYPE_FACTORY;

    public static XMLGregorianCalendar toGregorianLocalDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return DATATYPE_FACTORY.newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), Integer.MIN_VALUE);
    }

    public static XMLGregorianCalendar toGregorianLocalDateTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return DATATYPE_FACTORY.newXMLGregorianCalendar(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), Integer.MIN_VALUE);
    }

    public static XMLGregorianCalendar toGregorianDate(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return DATATYPE_FACTORY.newXMLGregorianCalendar(gc);
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

