/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jaxws;

import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.SecurityHelper;
import com.gridnine.xtrip.server.jaxws.FaultHandler;
import com.gridnine.xtrip.server.jaxws.HeaderListReturnHandler;
import com.gridnine.xtrip.server.jaxws.JaxWsProxyConfig;
import com.gridnine.xtrip.server.jaxws.LoggingHandler;
import com.gridnine.xtrip.server.jaxws.SoapNamespaceHandler;
import com.gridnine.xtrip.server.jaxws.WsRequest;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class JaxWsProxy {
    private static final Logger log = LoggerFactory.getLogger(JaxWsProxy.class);
    private Method invokeMethod;
    private Object delegate;

    private JaxWsProxy() {
    }

    static JaxWsProxy newInstance(JaxWsProxyConfig config) throws Exception {
        JaxWsProxy result = new JaxWsProxy();
        Method serviceClassMethod = null;
        for (Method method : config.getServiceClass().getMethods()) {
            if (method.getParameterTypes().length != 0 || method.getAnnotation(WebEndpoint.class) == null) continue;
            serviceClassMethod = method;
            log.debug("found no-arg, @WebEndpoint annotated method '{}'", (Object)method);
            break;
        }
        if (serviceClassMethod == null) {
            throw new IllegalStateException("could not find appropriate method in service class " + config.getServiceClass().getName());
        }
        Class<?> portTypeClass = serviceClassMethod.getReturnType();
        log.debug("determined port type class '{}'", portTypeClass);
        for (Method method : portTypeClass.getMethods()) {
            WebMethod webMethodAnnotation = method.getAnnotation(WebMethod.class);
            if (webMethodAnnotation == null || config.getMethodName() != null && !config.getMethodName().equals(method.getName())) continue;
            result.invokeMethod = method;
            log.debug("found @WebMethod annotated method '{}'", (Object)method);
            break;
        }
        if (result.invokeMethod == null) {
            throw new IllegalStateException("could not find appropriate method in port type class " + portTypeClass.getName());
        }
        ClassLoader cl = config.getServiceClass().getClassLoader();
        WebServiceClient webServiceClientAnn = config.getServiceClass().getAnnotation(WebServiceClient.class);
        String wsdlName = webServiceClientAnn.wsdlLocation().substring(webServiceClientAnn.wsdlLocation().lastIndexOf(47) + 1);
        log.debug("determined wsdl name '{}'", (Object)wsdlName);
        URL wsdlUrl = cl.getResource(TextUtil.join((String)"/", Arrays.asList(config.getWsdlFolder(), wsdlName)));
        log.debug("determined wsdl url '{}'", (Object)wsdlUrl);
        Object service = config.getServiceClass().getConstructor(URL.class, QName.class).newInstance(wsdlUrl, new QName(webServiceClientAnn.targetNamespace(), webServiceClientAnn.name()));
        log.debug("constructed service instance '{}'", service);
        result.delegate = serviceClassMethod.invoke(service, new Object[0]);
        log.debug("constructed proxy instance '{}'", result.delegate);
        BindingProvider bindingProvider = (BindingProvider)result.delegate;
        if (config.isUseSsl()) {
            JaxWsProxy.enableSsl(bindingProvider);
        }
        if (config.isUseTrustyHostnameVerifier()) {
            JaxWsProxy.enableTrustyHostnameVerifier(bindingProvider);
        }
        if (config.getAuthentication() != null) {
            JaxWsProxy.enableHttpAuthentication(bindingProvider, config.getAuthentication());
        }
        Map context = bindingProvider.getRequestContext();
        context.put("javax.xml.ws.service.endpoint.address", config.getEndpointAddress());
        if (config.getRequestTimeout() != null) {
            context.put("com.sun.xml.ws.request.timeout", config.getRequestTimeout());
        }
        HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
        httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
        bindingProvider.getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
        Binding binding = bindingProvider.getBinding();
        ArrayList<Object> handlerList = binding.getHandlerChain();
        if (handlerList == null) {
            handlerList = new ArrayList<Object>();
        }
        if (!TextUtil.isBlank((String)config.getDefaultNamespace())) {
            handlerList.add(new SoapNamespaceHandler(config.getDefaultNamespace()));
        }
        handlerList.add(new LoggingHandler());
        handlerList.add(new HeaderListReturnHandler());
        handlerList.add(new FaultHandler());
        binding.setHandlerChain(handlerList);
        log.info("initialized proxy '{}'", result.delegate);
        return result;
    }

    private static void enableSsl(BindingProvider bindingProvider) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(SecurityHelper.getInstance().getKeyStore(), DesUtil.decode((String)SecurityHelper.getInstance().getPassword()).toCharArray());
        KeyManager[] keyManagers = kmf.getKeyManagers();
        sc.init(keyManagers, trustAllCerts, new SecureRandom());
        bindingProvider.getRequestContext().put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", sc.getSocketFactory());
    }

    private static void enableTrustyHostnameVerifier(BindingProvider bindingProvider) {
        bindingProvider.getRequestContext().put("com.sun.xml.ws.transport.https.client.hostname.verifier", new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        });
    }

    private static void enableHttpAuthentication(BindingProvider bindingProvider, Pair<String> authentication) {
        bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.username", authentication.getFirst());
        bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.password", authentication.getLast());
    }

    <T> T invoke(WsRequest request) throws Exception {
        ArrayList<Object> args = new ArrayList<Object>(request.getHeaders().size() + 1);
        for (Object header : request.getHeaders()) {
            args.add(new Holder(header));
        }
        args.addAll(request.getPayload());
        return (T)this.invokeMethod.invoke(this.delegate, args.toArray());
    }
}

