/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jaxws;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.jaxws.InvocationContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Deprecated
class LoggingHandler
implements LogicalHandler<LogicalMessageContext> {
    private static final String KEY_INBOUND_PAYLOAD = LoggingHandler.class.getName() + ":inbound-payload";
    private static final String KEY_OUTBOUND_PAYLOAD = LoggingHandler.class.getName() + ":outbound-payload";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Date startDate = null;
    private Date endDate = null;

    LoggingHandler() {
    }

    public void close(MessageContext ctx) {
        if (!InvocationContext.get().isActive()) {
            return;
        }
        Document doc = DocumentBuilderHelper.newDocument();
        Element transaction = doc.createElement("transaction");
        Element request = doc.createElement("request");
        request.appendChild(doc.importNode((Element)ctx.get((Object)KEY_OUTBOUND_PAYLOAD), true));
        transaction.appendChild(request);
        Element response = doc.createElement("response");
        if (ctx.get((Object)KEY_INBOUND_PAYLOAD) != null) {
            response.appendChild(doc.importNode((Element)ctx.get((Object)KEY_INBOUND_PAYLOAD), true));
        } else {
            XHelper.writeInt((Element)response, (String)"code", (Integer)((Integer)ctx.get((Object)"javax.xml.ws.http.response.code")));
        }
        transaction.appendChild(response);
        transaction.setAttribute("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.startDate));
        if (this.endDate == null || this.endDate.before(this.startDate)) {
            this.endDate = new Date();
        }
        transaction.setAttribute("timing", String.valueOf(this.endDate.getTime() - this.startDate.getTime()));
        transaction.setAttribute("url", (String)ctx.get((Object)"javax.xml.ws.service.endpoint.address"));
        InvocationContext.get().addTransaction(new InvocationContext.TransactionWrapper(transaction, this.startDate));
    }

    public boolean handleFault(LogicalMessageContext ctx) {
        return this.handleMessage(ctx);
    }

    public boolean handleMessage(LogicalMessageContext ctx) {
        if (InvocationContext.get().isActive()) {
            try {
                boolean outbound = MiscUtil.isTrue((String)String.valueOf(ctx.get((Object)"javax.xml.ws.handler.message.outbound")));
                Element payload = this.buildPayload(ctx);
                if (!outbound) {
                    this.endDate = new Date();
                } else {
                    this.startDate = new Date();
                }
                ctx.put((Object)(outbound ? KEY_OUTBOUND_PAYLOAD : KEY_INBOUND_PAYLOAD), (Object)payload);
            }
            catch (Exception ex) {
                this.log.error("failed building payload", (Throwable)ex);
            }
        }
        return true;
    }

    private Element buildPayload(LogicalMessageContext ctx) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        XUtil.newTransformer().transform(ctx.getMessage().getPayload(), new DOMResult(doc));
        return doc.getDocumentElement();
    }
}

