/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jibx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class JiBXHelper {
    public static <T> T read(Class<T> clazz, InputStream in) throws JiBXException {
        return JiBXHelper.read(clazz, in, StandardCharsets.UTF_8);
    }

    public static <T> T read(Class<T> clazz, InputStream in, Charset charset) throws JiBXException {
        IBindingFactory factory = BindingDirectory.getFactory(clazz);
        IUnmarshallingContext unmarshaller = factory.createUnmarshallingContext();
        return (T)unmarshaller.unmarshalDocument(in, charset.name());
    }

    public static <T> T read(Class<T> clazz, byte[] raw) throws JiBXException, IOException {
        return JiBXHelper.read(clazz, raw, StandardCharsets.UTF_8);
    }

    public static <T> T read(Class<T> clazz, byte[] raw, Charset charset) throws JiBXException, IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(raw);){
            T t = JiBXHelper.read(clazz, in, charset);
            return t;
        }
    }

    public static void write(Object obj, OutputStream out) throws JiBXException {
        IBindingFactory factory = BindingDirectory.getFactory(obj.getClass());
        IMarshallingContext marshaller = factory.createMarshallingContext();
        marshaller.marshalDocument(obj, null, null, out);
    }

    public static byte[] write(Object obj) throws JiBXException, IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            JiBXHelper.write(obj, baos);
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static <T> String toString(T obj) throws Exception {
        return new String(JiBXHelper.write(obj));
    }
}

