/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jibx.logger;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocationContext {
    private static final ThreadLocal<InvocationContext> INSTANCE = new ThreadLocal<InvocationContext>(){

        @Override
        protected InvocationContext initialValue() {
            return new InvocationContext();
        }
    };
    private final List<Transaction> transactions = new ArrayList<Transaction>();
    private static final Logger log = LoggerFactory.getLogger(InvocationContext.class);
    private boolean active;

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public static InvocationContext get() {
        return INSTANCE.get();
    }

    public boolean isActive() {
        return this.active;
    }

    public void begin() {
        this.transactions.clear();
        this.active = true;
    }

    public void addTransaction(Transaction transaction) {
        if (this.active) {
            this.transactions.add(transaction);
        } else {
            log.warn("addTransaction() ignored because of non-active state, maybe you forgot to wrap your subroute with com.gridnine.xtrip.server.jibxws.LoggingAdvice?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document buildDocument() throws Exception {
        byte[] content;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (XMLStreamWriter writer = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(baos));){
                writer.writeStartDocument();
                writer.writeStartElement("ws-transactions");
                for (Transaction transaction : this.transactions) {
                    transaction.toXML(writer, baos);
                }
                writer.writeEndElement();
                writer.writeEndDocument();
            }
            content = baos.toByteArray();
        }
        Document document = new Document();
        document.setContent(content);
        document.setCheckSum(DigestUtils.md5Hex((byte[])document.getContent()));
        document.setContentType(ContentType.XML);
        document.setType(DocumentType.GDS_LOG);
        document.setCreated(new Date());
        return document;
    }

    public void end() {
        this.transactions.clear();
        this.active = false;
    }

    public static class Transaction {
        private String url;
        private Date startingTime;
        private Date finishingTime;
        private String timing;
        private final Envelope request = new Envelope();
        private final Envelope response = new Envelope();
        private ExceptionData exception;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Date getStartingTime() {
            return this.startingTime;
        }

        public void setStartingTime(Date startingTime) {
            this.startingTime = startingTime;
        }

        public Date getFinishingTime() {
            return this.finishingTime;
        }

        public void setFinishingTime(Date finishingTime) {
            this.finishingTime = finishingTime;
        }

        public String getTiming() {
            return this.timing;
        }

        public void setTiming(String timing) {
            this.timing = timing;
        }

        public Envelope getRequest() {
            return this.request;
        }

        public Envelope getResponse() {
            return this.response;
        }

        public ExceptionData getException() {
            return this.exception;
        }

        public void setException(ExceptionData exception) {
            this.exception = exception;
        }

        public void toXML(XMLStreamWriter writer, OutputStream os) throws Exception {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            writer.writeStartElement("transaction");
            writer.writeAttribute("url", this.url);
            writer.writeAttribute("startingTime", sdf.format(this.startingTime));
            if (this.finishingTime != null) {
                writer.writeAttribute("finishingTime", sdf.format(this.finishingTime));
            }
            if (this.timing != null) {
                writer.writeAttribute("timing", this.timing);
            }
            writer.writeStartElement("request");
            this.request.toXML(writer, os);
            writer.writeEndElement();
            writer.writeStartElement("response");
            this.response.toXML(writer, os);
            writer.writeEndElement();
            if (this.exception != null) {
                writer.writeStartElement("exception");
                writer.writeAttribute("finishingTime", sdf.format(this.exception.getFinishingDate()));
                writer.writeAttribute("timing", Long.toString(this.exception.getTiming()));
                writer.writeCData(TextUtil.getExceptionStackTraceRegular((Throwable)this.exception.getException()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        public static final class ExceptionData {
            public final Throwable exception;
            private final Date finishingDate;
            private final long timing;

            public ExceptionData(Throwable exception, long startingTime) {
                this.exception = exception;
                this.finishingDate = new Date();
                this.timing = this.finishingDate.getTime() - startingTime;
            }

            public Throwable getException() {
                return this.exception;
            }

            public Date getFinishingDate() {
                return this.finishingDate;
            }

            public long getTiming() {
                return this.timing;
            }
        }

        public static class Envelope {
            private byte[] payload;
            private Map<String, String[]> headers;

            public byte[] getPayload() {
                return this.payload;
            }

            public void setPayload(byte[] payload) {
                this.payload = payload;
            }

            public Map<String, String[]> getHeaders() {
                return this.headers;
            }

            public void setHeaders(Map<String, String[]> headers) {
                this.headers = headers;
            }

            public void toXML(XMLStreamWriter writer, OutputStream os) throws Exception {
                if (this.payload != null) {
                    writer.writeStartElement("http-headers");
                    for (Map.Entry<String, String[]> entry : this.headers.entrySet()) {
                        for (String value : entry.getValue()) {
                            writer.writeStartElement("http-header");
                            if (TextUtil.nonBlank((String)entry.getKey())) {
                                writer.writeAttribute("name", entry.getKey());
                            }
                            writer.writeAttribute("value", value);
                            writer.writeEndElement();
                        }
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("payload");
                    writer.writeCharacters("");
                    writer.flush();
                    MiscUtil.writeBytesWithoutXmlHeader((OutputStream)os, (byte[])this.payload);
                    os.flush();
                    writer.writeEndElement();
                } else {
                    writer.writeAttribute("empty", "true");
                }
            }
        }
    }
}

