/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jibx.logger;

import com.github.rwitzel.streamflyer.core.Modifier;
import com.github.rwitzel.streamflyer.core.ModifyingReader;
import com.github.rwitzel.streamflyer.regex.RegexModifier;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.jibx.logger.InvocationContext;
import com.gridnine.xtrip.server.jibx.logger.LoggingOutputHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.input.ReaderInputStream;
import org.jibx.ws.context.InContext;
import org.jibx.ws.http.client.HttpInConnection;
import org.jibx.ws.http.client.HttpInputStreamInterceptor;
import org.jibx.ws.io.CopiedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInputHandler
implements HttpInputStreamInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private InputStream cis;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
    private final LoggingOutputHandler loggingOutputHandler;
    private final Map<String, String[]> headers = new HashMap<String, String[]>();
    private final boolean createTransaction;
    private HttpInConnection inConnection;
    private InvocationContext.Transaction.ExceptionData exception;
    private final String url;
    private final MiscUtil.Pair<String, String> findAndReplacePair;

    public LoggingInputHandler(boolean createTransaction, String url, LoggingOutputHandler loggingOutputHandler, MiscUtil.Pair<String, String> findAndReplacePair) {
        this.createTransaction = createTransaction;
        this.url = url;
        this.loggingOutputHandler = loggingOutputHandler;
        this.findAndReplacePair = findAndReplacePair;
    }

    public Map<String, String[]> getHeaders() {
        return this.headers;
    }

    public void beginInput() {
        this.headers.clear();
        this.headers.putAll(this.inConnection.getProperties());
    }

    public void setInConnection(HttpInConnection inConnection) {
        this.inConnection = inConnection;
    }

    public void addException(Throwable t, long startingTime) {
        this.exception = new InvocationContext.Transaction.ExceptionData(t, startingTime);
    }

    public void inputComplete() {
        this.tail();
    }

    public void tail() {
        try {
            byte[] buff = new byte[8192];
            while (this.cis.read(buff, 0, buff.length) > 0) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void inputComplete2() {
        try {
            if (!this.createTransaction) {
                return;
            }
            InvocationContext.Transaction transaction = this.loggingOutputHandler.getTransaction();
            Date startingTime = this.loggingOutputHandler.getStartingTime();
            boolean created = false;
            if (transaction == null) {
                transaction = new InvocationContext.Transaction();
                transaction.setUrl(this.url);
                transaction.setStartingTime(startingTime);
                created = true;
            }
            if (this.cis != null) {
                this.tail();
                if (this.out.size() != 0) {
                    transaction.getResponse().setHeaders(Collections.unmodifiableMap(this.headers));
                    transaction.getResponse().setPayload(this.out.toByteArray());
                }
            }
            Date finishingTime = new Date();
            transaction.setFinishingTime(finishingTime);
            transaction.setTiming(startingTime != null ? String.valueOf(finishingTime.getTime() - startingTime.getTime()) : "(unknown)");
            transaction.setException(this.exception);
            if (created) {
                InvocationContext.get().addTransaction(transaction);
            }
            this.out.reset();
            this.exception = null;
        }
        catch (Exception ex) {
            this.log.error("failed building payload", (Throwable)ex);
        }
    }

    private static InputStream findAndReplace(InputStream inputStream, MiscUtil.Pair<String, String> findAndReplacePair) {
        InputStreamReader originalReader = new InputStreamReader(inputStream);
        RegexModifier modifier = new RegexModifier((String)findAndReplacePair.getFirst(), 0, (String)findAndReplacePair.getSecond());
        ModifyingReader modifyingReader = new ModifyingReader((Reader)originalReader, (Modifier)modifier);
        return new ReaderInputStream((Reader)modifyingReader);
    }

    public InputStream intercept(InputStream inputStream) {
        InputStream is = inputStream;
        if (this.createTransaction) {
            is = new CopiedInputStream(is, (OutputStream)this.out);
        }
        if (this.findAndReplacePair != null) {
            is = LoggingInputHandler.findAndReplace(is, this.findAndReplacePair);
        }
        this.cis = is;
        return this.cis;
    }

    public void setMessageContext(InContext ctx) {
    }
}

