/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jibx.logger;

import com.github.rwitzel.streamflyer.core.Modifier;
import com.github.rwitzel.streamflyer.core.ModifyingWriter;
import com.github.rwitzel.streamflyer.regex.RegexModifier;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.jibx.logger.InvocationContext;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.output.WriterOutputStream;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.http.client.HttpOutConnection;
import org.jibx.ws.http.client.HttpOutputStreamInterceptor;
import org.jibx.ws.io.CopiedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingOutputHandler
implements HttpOutputStreamInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
    private Date startingTime = new Date();
    private InvocationContext.Transaction transaction;
    private final Map<String, String[]> headers = new HashMap<String, String[]>();
    private final boolean createTransaction;
    private HttpOutConnection outConnection;
    private final String url;
    private final MiscUtil.Pair<String, String> findAndReplacePair;
    private static final String USER_AGENT = String.format("MidOffice/3.0 (%s; %s; x%s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("sun.arch.data.model"));

    public LoggingOutputHandler(boolean createTransaction, String url, Map<String, String[]> headers, MiscUtil.Pair<String, String> findAndReplacePair) {
        this.createTransaction = createTransaction;
        this.url = url;
        this.headers.put("User-Agent", new String[]{USER_AGENT});
        this.headers.putAll(headers);
        this.findAndReplacePair = findAndReplacePair;
    }

    public Date getStartingTime() {
        return this.startingTime;
    }

    public InvocationContext.Transaction getTransaction() {
        return this.transaction;
    }

    public void beginOutput() {
        this.headers.clear();
        this.headers.putAll(this.outConnection.getProperties());
        this.startingTime = new Date();
    }

    public void setOutConnection(HttpOutConnection outConnection) {
        this.outConnection = outConnection;
        outConnection.setProperties(this.headers);
    }

    public void outputComplete() {
    }

    public void outputComplete2() {
        try {
            if (!this.createTransaction) {
                return;
            }
            this.transaction = new InvocationContext.Transaction();
            this.transaction.setUrl(this.url);
            this.transaction.setStartingTime(this.startingTime);
            if (this.out.size() != 0) {
                this.transaction.getRequest().setHeaders(new HashMap<String, String[]>(this.headers));
                this.transaction.getRequest().setPayload(this.out.toByteArray());
            }
            InvocationContext.get().addTransaction(this.transaction);
            this.out.reset();
        }
        catch (Exception ex) {
            this.log.error("failed building payload", (Throwable)ex);
        }
    }

    private static OutputStream findAndReplace(OutputStream outputStream, MiscUtil.Pair<String, String> findAndReplacePair) {
        OutputStreamWriter originalWriter = new OutputStreamWriter(outputStream);
        RegexModifier modifier = new RegexModifier((String)findAndReplacePair.getFirst(), 0, (String)findAndReplacePair.getSecond());
        ModifyingWriter modifyingWriter = new ModifyingWriter((Writer)originalWriter, (Modifier)modifier);
        return new WriterOutputStream((Writer)modifyingWriter);
    }

    public OutputStream intercept(OutputStream outputStream) {
        OutputStream os = outputStream;
        if (this.createTransaction) {
            os = new CopiedOutputStream(os, (OutputStream)this.out);
        }
        if (this.findAndReplacePair != null) {
            os = LoggingOutputHandler.findAndReplace(os, this.findAndReplacePair);
        }
        return os;
    }

    public void setMessageContext(OutContext ctx) {
    }
}

