/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jibx.tools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Customize {
    public static void main(String[] args) throws Exception {
        String path = args[0];
        String file = args[1];
        Customize.customize(new File(path), new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void customize(final File path, File file) throws Exception {
        try (FileInputStream is = new FileInputStream(file);){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)is, new DefaultHandler(){
                private File bindingName = null;
                private String elementPath = null;
                private String elementText = null;
                private boolean isElement = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    block10: {
                        try {
                            int idx;
                            if ("binding".equals(qName)) {
                                this.bindingName = new File(path, attributes.getValue("name") + ".xml");
                                return;
                            }
                            if ("element".equals(qName)) {
                                this.isElement = true;
                                this.elementText = null;
                                this.elementPath = attributes.getValue("path");
                                return;
                            }
                            if (!"attribute".equals(qName)) break block10;
                            String attributePath = attributes.getValue("path");
                            String value = attributes.getValue("value");
                            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                            Document doc = docBuilder.parse(this.bindingName);
                            XPath xpath = XPathFactory.newInstance().newXPath();
                            NodeList nodes = (NodeList)xpath.evaluate(attributePath, doc, XPathConstants.NODESET);
                            if (nodes.getLength() == 0) {
                                throw new SAXException("no match found. " + attributePath);
                            }
                            if (value != null) {
                                for (idx = 0; idx < nodes.getLength(); ++idx) {
                                    nodes.item(idx).setNodeValue(value);
                                }
                            } else {
                                for (idx = 0; idx < nodes.getLength(); ++idx) {
                                    Attr attr = (Attr)nodes.item(idx);
                                    Element parent = attr.getOwnerElement();
                                    parent.removeAttributeNode(attr);
                                }
                            }
                            TransformerFactory transformerFactory = TransformerFactory.newInstance();
                            Transformer transformer = transformerFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            DOMSource source = new DOMSource(doc);
                            StreamResult result = new StreamResult(this.bindingName);
                            transformer.transform(source, result);
                            return;
                        }
                        catch (SAXException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new SAXException(e);
                        }
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    block9: {
                        try {
                            if ("binding".equals(qName)) {
                                this.bindingName = null;
                                return;
                            }
                            if (!"element".equals(qName)) break block9;
                            this.isElement = false;
                            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                            Document doc = docBuilder.parse(this.bindingName);
                            XPath xpath = XPathFactory.newInstance().newXPath();
                            NodeList nodes = (NodeList)xpath.evaluate(this.elementPath, doc, XPathConstants.NODESET);
                            if (nodes.getLength() == 0) {
                                throw new SAXException("no match found. " + this.elementPath);
                            }
                            if (this.elementText != null) {
                                Element newNode = docBuilder.parse(new ByteArrayInputStream(this.elementText.getBytes())).getDocumentElement();
                                for (int idx = 0; idx < nodes.getLength(); ++idx) {
                                    Node oldNode = nodes.item(idx);
                                    Node parent = oldNode.getParentNode();
                                    Node importedNode = parent.getOwnerDocument().importNode(newNode, true);
                                    parent.replaceChild(importedNode, oldNode);
                                }
                            } else {
                                for (int idx = 0; idx < nodes.getLength(); ++idx) {
                                    Node node = nodes.item(idx);
                                    Node parent = node.getParentNode();
                                    parent.removeChild(node);
                                }
                            }
                            TransformerFactory transformerFactory = TransformerFactory.newInstance();
                            Transformer transformer = transformerFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            DOMSource source = new DOMSource(doc);
                            StreamResult result = new StreamResult(this.bindingName);
                            transformer.transform(source, result);
                            this.elementPath = null;
                            this.elementText = null;
                            return;
                        }
                        catch (SAXException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new SAXException(e);
                        }
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) {
                    if (this.isElement) {
                        this.elementText = this.elementText != null ? this.elementText + new String(ch, start, length) : new String(ch, start, length);
                    }
                }
            });
        }
    }
}

