/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jibxpox;

import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibx.logger.InvocationContext;
import com.gridnine.xtrip.server.jibx.logger.LoggingInputHandler;
import com.gridnine.xtrip.server.jibx.logger.LoggingOutputHandler;
import com.gridnine.xtrip.server.jibxpox.IBusPoxContextKeys;
import com.gridnine.xtrip.server.jibxpox.PoxRequest;
import com.gridnine.xtrip.server.jibxpox.PoxResponse;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.ws.http.client.HttpTransportOptions;
import org.jibx.ws.pox.client.PoxClient;
import org.jibx.ws.transport.TransportOptions;
import org.jibx.ws.transport.interceptor.InputStreamInterceptor;
import org.jibx.ws.transport.interceptor.OutputStreamInterceptor;

public class JiBXPOXInvoker
extends BaseProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        boolean createTransaction = InvocationContext.get().isActive();
        PoxRequest request = (PoxRequest)ctx.getMandatoryObject((Enum)IBusPoxContextKeys.POX_REQUEST);
        Object payload = request.getPayload();
        IBindingFactory factory = BindingDirectory.getFactory(payload.getClass());
        String url = request.getEndpointAddress();
        PoxClient client = new PoxClient(url, factory);
        HttpTransportOptions transportOptions = new HttpTransportOptions();
        LoggingOutputHandler loggingOutputHandler = new LoggingOutputHandler(createTransaction, url, null, null);
        transportOptions.setOutputStreamInterceptor((OutputStreamInterceptor)loggingOutputHandler);
        LoggingInputHandler loggingInputHandler = new LoggingInputHandler(createTransaction, url, loggingOutputHandler, null);
        transportOptions.setInputStreamInterceptor((InputStreamInterceptor)loggingInputHandler);
        if (request.getConnectionTimeout() != null) {
            transportOptions.setConnectTimeout(request.getConnectionTimeout());
        }
        if (request.getRequestTimeout() != null) {
            transportOptions.setConnectTimeout(request.getRequestTimeout());
        }
        client.setTransportOptions((TransportOptions)transportOptions);
        PoxResponse response = new PoxResponse();
        try {
            long startingTime = System.currentTimeMillis();
            try {
                response.setPayload(client.call(payload));
            }
            catch (Throwable t) {
                loggingInputHandler.addException(t, startingTime);
                throw t;
            }
        }
        finally {
            loggingOutputHandler.outputComplete2();
            loggingInputHandler.inputComplete2();
        }
        ctx.putObject((Enum)IBusPoxContextKeys.POX_RESPONSE, (Object)response);
        ctx.putObject((Enum)IBusPoxContextKeys.POX_REQUEST, null);
    }
}

