/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jibxws;

import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.SecurityHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibx.logger.InvocationContext;
import com.gridnine.xtrip.server.jibx.logger.LoggingInputHandler;
import com.gridnine.xtrip.server.jibx.logger.LoggingOutputHandler;
import com.gridnine.xtrip.server.jibxws.ContentEncoding;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import com.gridnine.xtrip.server.jibxws.ResponseHeaderHandler;
import com.gridnine.xtrip.server.jibxws.WSSecurity;
import com.gridnine.xtrip.server.jibxws.WsParts;
import com.gridnine.xtrip.server.jibxws.WsRequest;
import com.gridnine.xtrip.server.jibxws.WsResponse;
import com.gridnine.xtrip.server.util.ErrorsHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.setup.InboundWSSec;
import org.apache.wss4j.stax.setup.OutboundWSSec;
import org.apache.wss4j.stax.setup.WSSec;
import org.apache.xml.security.stax.ext.SecurePart;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.JiBXException;
import org.jibx.ws.WsException;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.http.client.HttpInConnection;
import org.jibx.ws.http.client.HttpInputStreamInterceptor;
import org.jibx.ws.http.client.HttpOutConnection;
import org.jibx.ws.http.client.HttpOutputStreamInterceptor;
import org.jibx.ws.http.client.HttpTransportOptions;
import org.jibx.ws.io.MessageOptions;
import org.jibx.ws.io.handler.InHandler;
import org.jibx.ws.protocol.Protocol;
import org.jibx.ws.protocol.ProtocolDirectory;
import org.jibx.ws.soap.SoapVersion;
import org.jibx.ws.soap.client.SoapClient;
import org.jibx.ws.transport.TransportOptions;
import org.jibx.ws.transport.WsTransportException;
import org.jibx.ws.transport.interceptor.InputStreamInterceptor;
import org.jibx.ws.transport.interceptor.OutputStreamInterceptor;

public class JiBXWSInvoker
extends BaseProcessor {
    private static final TrustManager[] TRUST_MANAGERS = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    private static final HostnameVerifier TRUSTFUL_HOSTNAME_VERIFIER = (hostname, session) -> true;
    private static final String TAG_SOAP11_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String TAG_SOAP12_NAMESPACE = "http://www.w3.org/2003/05/soap-envelope";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        WsRequest request = (WsRequest)ctx.getMandatoryObject((Enum)IBusJibxWsContextKeys.WS_REQUEST);
        WsResponse response = new WsResponse();
        Object payload = request.getPayload();
        int numAttempts = 3;
        boolean success = false;
        try {
            for (int i = 0; i < numAttempts && !success; ++i) {
                SoapObjectBundle bundle = new SoapObjectBundle(request, response);
                try {
                    long startingTime = System.currentTimeMillis();
                    try {
                        response.setPayload(bundle.getClient().call(payload));
                    }
                    catch (Throwable t) {
                        bundle.getLoggingInputHandler().addException(t, startingTime);
                        throw t;
                    }
                    response.setHttpHeaders(bundle.getLoggingInputHandler().getHeaders());
                    success = true;
                    continue;
                }
                catch (Throwable e) {
                    Throwable unwrappedE = JiBXWSInvoker.unwrap(e);
                    boolean rethrow = true;
                    if (!request.getIgnoredException().isEmpty() && i != numAttempts - 1 && (request.isSubclassExceptionsIncluded() ? request.getIgnoredException().stream().anyMatch(c -> c.isInstance(unwrappedE)) : request.getIgnoredException().contains(unwrappedE.getClass()))) {
                        bundle.getLoggingOutputHandler().outputComplete2();
                        bundle.getLoggingInputHandler().inputComplete2();
                        continue;
                    }
                    try {
                        String message;
                        if (unwrappedE instanceof IOException) {
                            boolean bl = rethrow = !ErrorsHelper.get().specify((IOException)unwrappedE);
                        }
                        if (unwrappedE instanceof SSLHandshakeException && (message = unwrappedE.getMessage()) != null) {
                            if (message.startsWith("Remote host closed connection during handshake")) {
                                throw Xeption.forEndUser((String)("\u0423\u0434\u0430\u043b\u0451\u043d\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440 \u0440\u0430\u0437\u043e\u0440\u0432\u0430\u043b \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435. URL: " + request.getEndpointAddress()), (Object[])new Object[0]);
                            }
                            if (message.startsWith("Couldn't kickstart handshaking")) {
                                throw Xeption.forEndUser((String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435. URL: " + request.getEndpointAddress()), (Object[])new Object[0]);
                            }
                        }
                        if (unwrappedE instanceof WsTransportException && (message = unwrappedE.getMessage()) != null) {
                            if (message.startsWith("503 Service Temporarily Unavailable") || message.startsWith("503 Service Unavailable")) {
                                throw Xeption.forEndUser((String)("503 \u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d. URL: " + request.getEndpointAddress()), (Throwable)unwrappedE, (Object[])new Object[0]);
                            }
                            if (message.startsWith("502 Bad Gateway")) {
                                throw Xeption.forEndUser((String)("502 \u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0448\u043b\u044e\u0437. URL: " + request.getEndpointAddress()), (Throwable)unwrappedE, (Object[])new Object[0]);
                            }
                            if (message.startsWith("504 Gateway Time-out")) {
                                throw Xeption.forEndUser((String)("504 \u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0430\u0435\u0442. URL: " + request.getEndpointAddress()), (Throwable)unwrappedE, (Object[])new Object[0]);
                            }
                            if (message.startsWith("500 Internal Server Error") || message.contains("HTTP Status 500")) {
                                throw Xeption.forEndUser((String)("500 \u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430. URL: " + request.getEndpointAddress()), (Throwable)unwrappedE, (Object[])new Object[0]);
                            }
                            if (message.startsWith("404 Not Found")) {
                                StackTraceElement endpointAddress = new StackTraceElement("<<Context>>", "endpointAddress", request.getEndpointAddress(), -1);
                                IncidentsHelper.addStackTraceElement((Throwable)unwrappedE, (StackTraceElement[])new StackTraceElement[]{endpointAddress});
                                throw Xeption.forEndUser((String)("404 \u0420\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. URL: " + request.getEndpointAddress()), (Throwable)unwrappedE, (Object[])new Object[0]);
                            }
                        }
                        if (!rethrow) continue;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        bundle.getLoggingOutputHandler().outputComplete2();
                        bundle.getLoggingInputHandler().inputComplete2();
                    }
                }
            }
        }
        catch (WsException ex) {
            InvocationContext.Transaction lastTransaction;
            List<InvocationContext.Transaction> transactions;
            if ("No handlers could be found for unmarshalling the SOAP body payload".equals(ex.getMessage()) && !(transactions = InvocationContext.get().getTransactions()).isEmpty() && (lastTransaction = transactions.get(transactions.size() - 1)) != null && lastTransaction.getResponse() != null && lastTransaction.getResponse().getPayload() != null) {
                IncidentsHelper.addStackTraceElement((Throwable)ex, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"responsePayload", (String)new String(lastTransaction.getResponse().getPayload()))});
            }
            throw ex;
        }
        if (!success) {
            throw Xeption.forAdmin((String)("\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. URL: " + request.getEndpointAddress()), (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusJibxWsContextKeys.WS_RESPONSE, (Object)response);
        ctx.putObject((Enum)IBusJibxWsContextKeys.WS_REQUEST, null);
    }

    private static Throwable unwrap(Throwable e) {
        if (e instanceof WsException) {
            WsException wse = (WsException)e;
            if (wse.getRootCause() != null) {
                return JiBXWSInvoker.unwrap(wse.getRootCause());
            }
            if (wse.getCause() != null) {
                return JiBXWSInvoker.unwrap(wse.getCause());
            }
        }
        if (e instanceof JiBXException && e.getCause() != null) {
            return JiBXWSInvoker.unwrap(e.getCause());
        }
        if (e instanceof SSLException) {
            if (e.getCause() != null) {
                return JiBXWSInvoker.unwrap(e.getCause());
            }
            if (e.getSuppressed() != null && e.getSuppressed().length == 1) {
                return JiBXWSInvoker.unwrap(e.getSuppressed()[0]);
            }
        }
        return e;
    }

    private static void addInterceptors(List<OutputStreamInterceptor> outputInterceptors, List<InputStreamInterceptor> inputInterceptors, Object ... interceptors) {
        if (null == interceptors) {
            return;
        }
        for (Object i : interceptors) {
            if (i instanceof OutputStreamInterceptor) {
                outputInterceptors.add((OutputStreamInterceptor)i);
                continue;
            }
            if (!(i instanceof InputStreamInterceptor)) continue;
            inputInterceptors.add((InputStreamInterceptor)i);
        }
    }

    private static Object[] getSecurityInterceptor(WSSecurity security, SoapVersion soapVersion) {
        if (security != null) {
            WSSecurity.Algorithm keyTransportAlgorithm;
            WSSecurity.Algorithm symAlgorithm;
            WSSecurity.Algorithm digestAlgorithm;
            WSSecurity.Algorithm canonicalizationAlgorithm;
            final WSSSecurityProperties securityProperties = new WSSSecurityProperties();
            Merlin merlin = new Merlin();
            merlin.setKeyStore(security.getKeyStore());
            merlin.setTrustStore(security.getTrustStore());
            securityProperties.setCallbackHandler(callbacks -> {
                WSPasswordCallback passwordCallback;
                if (callbacks[0] instanceof WSPasswordCallback && (passwordCallback = (WSPasswordCallback)callbacks[0]).getIdentifier().equals(security.getKeyStoreAlias())) {
                    passwordCallback.setPassword(new String(security.getKeyStorePswd()));
                }
            });
            securityProperties.setUseSingleCert(security.isUseSingleCert());
            WSSecurity.Signature signature = security.getSignature();
            WSSecurity.Encryption encryption = security.getEncryption();
            WSSecurity.ProtectionOrder protectionOrder = security.getProtectionOrder();
            if (null == protectionOrder) {
                protectionOrder = WSSecurity.ProtectionOrder.SIGN_BEFORE_ENCRYPTING;
            }
            switch (protectionOrder) {
                case SIGN_BEFORE_ENCRYPTING: {
                    if (!signature.getParts().getParts().isEmpty()) {
                        securityProperties.addAction(WSSConstants.SIGNATURE);
                    }
                    if (encryption.getParts().getParts().isEmpty()) break;
                    securityProperties.addAction(WSSConstants.ENCRYPT);
                    break;
                }
                case ENCRYPT_BEFORE_SIGNING: {
                    if (!encryption.getParts().getParts().isEmpty()) {
                        securityProperties.addAction(WSSConstants.ENCRYPT);
                    }
                    if (signature.getParts().getParts().isEmpty()) break;
                    securityProperties.addAction(WSSConstants.SIGNATURE);
                }
            }
            securityProperties.setSignatureUser(security.getKeyStoreAlias());
            securityProperties.setSignatureCrypto((Crypto)merlin);
            WSSecurity.Algorithm signatureAlgorithm = signature.getAlgorithm();
            if (signatureAlgorithm != null) {
                securityProperties.setSignatureAlgorithm(signatureAlgorithm.getId());
            }
            if ((canonicalizationAlgorithm = signature.getCanonicalizationAlgorithm()) != null) {
                securityProperties.setSignatureCanonicalizationAlgorithm(canonicalizationAlgorithm.getId());
            }
            if ((digestAlgorithm = signature.getDigestAlgorithm()) != null) {
                securityProperties.setSignatureDigestAlgorithm(digestAlgorithm.getId());
            }
            securityProperties.setIncludeSignatureToken(signature.isIncludeToken());
            WSSecurity.Parts signatureParts = signature.getParts();
            List<Object> parts = null;
            if (signatureParts != null) {
                parts = signatureParts.getParts().stream().map(p -> JiBXWSInvoker.transform(p, soapVersion)).collect(Collectors.toList());
                securityProperties.getSignatureSecureParts().addAll(parts);
            }
            securityProperties.setEncryptionCrypto((Crypto)merlin);
            securityProperties.setEncryptionUser(security.getTrustStoreAlias());
            WSSecurity.Parts encryptionParts = signature.getParts();
            if (!Objects.equals(signatureParts, encryptionParts)) {
                parts = encryptionParts != null ? encryptionParts.getParts().stream().map(p -> JiBXWSInvoker.transform(p, soapVersion)).collect(Collectors.toList()) : null;
            }
            if (parts != null) {
                securityProperties.getEncryptionSecureParts().addAll(parts);
            }
            if ((symAlgorithm = encryption.getSymAlgorithm()) != null) {
                securityProperties.setEncryptionSymAlgorithm(symAlgorithm.getId());
            }
            if ((keyTransportAlgorithm = encryption.getKeyTransportAlgorithm()) != null) {
                securityProperties.setEncryptionKeyTransportAlgorithm(keyTransportAlgorithm.getId());
            }
            securityProperties.setIncludeEncryptionToken(encryption.isIncludeToken());
            securityProperties.setSignatureVerificationCrypto((Crypto)merlin);
            securityProperties.setDecryptionCrypto((Crypto)merlin);
            OutputStreamInterceptor outputInterceptor = new OutputStreamInterceptor(){

                public OutputStream intercept(final OutputStream outputStream) {
                    return new ByteArrayOutputStream(){

                        @Override
                        public void close() throws IOException {
                            this.flush();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void flush() throws IOException {
                            try (ByteArrayInputStream in = new ByteArrayInputStream(this.toByteArray());
                                 XMLStreamReader xmlStreamReader = XSUtil.getXMLInputFactory().createXMLStreamReader(in, StandardCharsets.UTF_8.name());
                                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                                OutboundWSSec wsSecOut = WSSec.getOutboundWSSec((WSSSecurityProperties)securityProperties);
                                try (XMLStreamWriter xmlStreamWriter = wsSecOut.processOutMessage((OutputStream)out, StandardCharsets.UTF_8.name(), Collections.emptyList());){
                                    JiBXWSInvoker.pumpAll(xmlStreamReader, xmlStreamWriter);
                                }
                                out.writeTo(outputStream);
                            }
                            catch (XMLStreamException | WSSecurityException e) {
                                ExceptionUtil.throwException((Throwable)e);
                            }
                        }
                    };
                }

                public void setMessageContext(OutContext outContext) {
                }

                public void outputComplete() {
                }
            };
            InputStreamInterceptor inputInterceptor = new InputStreamInterceptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive exception aggregation
                 */
                public InputStream intercept(InputStream inputStream) {
                    try (XMLStreamReader reader = XSUtil.getXMLInputFactory().createXMLStreamReader(inputStream, StandardCharsets.UTF_8.name());){
                        ByteArrayInputStream byteArrayInputStream;
                        InboundWSSec wsSecIn = WSSec.getInboundWSSec((WSSSecurityProperties)securityProperties, (boolean)false, (boolean)true);
                        XMLStreamReader inXmlStreamReader = wsSecIn.processInMessage(reader);
                        try {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            try (XMLStreamWriter inXmlStreamWriter = XSUtil.getXMLOutputFactory().createXMLStreamWriter(out, StandardCharsets.UTF_8.name());){
                                JiBXWSInvoker.pumpAll(inXmlStreamReader, inXmlStreamWriter);
                            }
                            byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
                        }
                        catch (Throwable throwable) {
                            inXmlStreamReader.close();
                            throw throwable;
                        }
                        inXmlStreamReader.close();
                        return byteArrayInputStream;
                    }
                    catch (XMLStreamException | WSSecurityException e) {
                        ExceptionUtil.throwException((Throwable)e);
                        return null;
                    }
                }

                public void setMessageContext(InContext inContext) {
                }

                public void inputComplete() {
                }
            };
            return new Object[]{outputInterceptor, inputInterceptor};
        }
        return null;
    }

    private static SecurePart transform(WSSecurity.Part part, SoapVersion soapVersion) {
        QName name = part.getName();
        if ("SOAP".equalsIgnoreCase(name.getPrefix())) {
            name = new QName(SoapVersion.SOAP1_1.equals(soapVersion) ? TAG_SOAP11_NAMESPACE : TAG_SOAP12_NAMESPACE, name.getLocalPart(), name.getPrefix());
        }
        return new SecurePart(name, part.getModifier() != null ? (WSSecurity.Modifier.CONTENT.equals((Object)part.getModifier()) ? SecurePart.Modifier.Content : SecurePart.Modifier.Element) : null);
    }

    private static void pumpAll(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        while (reader.hasNext()) {
            JiBXWSInvoker.pump(reader, writer);
            reader.next();
        }
        JiBXWSInvoker.pump(reader, writer);
        writer.flush();
    }

    private static void pump(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        switch (reader.getEventType()) {
            case 1: {
                int i;
                String localName = reader.getLocalName();
                String namespaceURI = reader.getNamespaceURI();
                if (namespaceURI != null && namespaceURI.length() > 0) {
                    String prefix = reader.getPrefix();
                    if (prefix != null) {
                        writer.writeStartElement(prefix, localName, namespaceURI);
                    } else {
                        writer.writeStartElement(namespaceURI, localName);
                    }
                } else {
                    writer.writeStartElement(localName);
                }
                int len = reader.getNamespaceCount();
                for (i = 0; i < len; ++i) {
                    writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                }
                len = reader.getAttributeCount();
                for (i = 0; i < len; ++i) {
                    String attUri = reader.getAttributeNamespace(i);
                    if (TextUtil.nonBlank((String)attUri)) {
                        writer.writeAttribute(attUri, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                        continue;
                    }
                    writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                }
                return;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 3: {
                writer.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                break;
            }
            case 4: 
            case 6: {
                writer.writeCharacters(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                break;
            }
            case 5: {
                writer.writeComment(reader.getText());
                break;
            }
            case 7: {
                String prefix = reader.getCharacterEncodingScheme();
                String version = reader.getVersion();
                if (prefix != null && version != null) {
                    writer.writeStartDocument(prefix, version);
                    break;
                }
                if (version == null) break;
                writer.writeStartDocument(reader.getVersion());
                break;
            }
            case 8: {
                writer.writeEndDocument();
                break;
            }
            case 9: {
                writer.writeEntityRef(reader.getLocalName());
            }
            default: {
                break;
            }
            case 11: {
                writer.writeDTD(reader.getText());
                break;
            }
            case 12: {
                writer.writeCData(reader.getText());
            }
        }
    }

    private static class InputInterceptorsContainer
    implements HttpInputStreamInterceptor {
        private final List<InputStreamInterceptor> interceptors = new ArrayList<InputStreamInterceptor>();

        InputInterceptorsContainer(List<InputStreamInterceptor> interceptors) {
            this.interceptors.addAll(interceptors);
        }

        public void setInConnection(HttpInConnection httpInConnection) {
            for (InputStreamInterceptor i : this.interceptors) {
                if (!(i instanceof HttpInputStreamInterceptor)) continue;
                ((HttpInputStreamInterceptor)i).setInConnection(httpInConnection);
            }
        }

        public void beginInput() {
            for (InputStreamInterceptor i : this.interceptors) {
                if (!(i instanceof HttpInputStreamInterceptor)) continue;
                ((HttpInputStreamInterceptor)i).beginInput();
            }
        }

        public void setMessageContext(InContext inContext) {
            for (InputStreamInterceptor i : this.interceptors) {
                i.setMessageContext(inContext);
            }
        }

        public InputStream intercept(InputStream inputStream) {
            InputStream result = inputStream;
            for (InputStreamInterceptor i : this.interceptors) {
                result = i.intercept(result);
            }
            return result;
        }

        public void inputComplete() {
            for (InputStreamInterceptor i : this.interceptors) {
                i.inputComplete();
            }
        }
    }

    private static class OutputInterceptorsContainer
    implements HttpOutputStreamInterceptor {
        private final List<OutputStreamInterceptor> interceptors = new ArrayList<OutputStreamInterceptor>();

        OutputInterceptorsContainer(List<OutputStreamInterceptor> interceptors) {
            this.interceptors.addAll(interceptors);
        }

        public void setOutConnection(HttpOutConnection httpOutConnection) {
            for (OutputStreamInterceptor i : this.interceptors) {
                if (!(i instanceof HttpOutputStreamInterceptor)) continue;
                ((HttpOutputStreamInterceptor)i).setOutConnection(httpOutConnection);
            }
        }

        public void beginOutput() {
            for (OutputStreamInterceptor i : this.interceptors) {
                if (!(i instanceof HttpOutputStreamInterceptor)) continue;
                ((HttpOutputStreamInterceptor)i).beginOutput();
            }
        }

        public void setMessageContext(OutContext outContext) {
            for (OutputStreamInterceptor i : this.interceptors) {
                i.setMessageContext(outContext);
            }
        }

        public void outputComplete() {
            for (OutputStreamInterceptor i : this.interceptors) {
                i.outputComplete();
            }
        }

        public OutputStream intercept(OutputStream outputStream) {
            OutputStream result = outputStream;
            for (OutputStreamInterceptor i : this.interceptors) {
                result = i.intercept(result);
            }
            return result;
        }
    }

    private static class SoapObjectBundle {
        private final SoapClient client;
        private final LoggingOutputHandler loggingOutputHandler;
        private final LoggingInputHandler loggingInputHandler;

        public SoapObjectBundle(WsRequest request, WsResponse response) throws Exception {
            String[] acceptTypes;
            SoapVersion soapVersion;
            Protocol protocol;
            boolean createTransaction = InvocationContext.get().isActive();
            Object payload = request.getPayload();
            IBindingFactory payloadFactory = BindingDirectory.getFactory(payload instanceof WsParts ? ((WsParts)payload).gerFirst().getClass() : payload.getClass());
            IBindingFactory headerFactory = request.getHeaders().isEmpty() ? payloadFactory : BindingDirectory.getFactory(request.getHeaders().get(0).getClass());
            String url = request.getEndpointAddress();
            this.client = new SoapClient(url, payloadFactory);
            if (request.getSeparateBodyResponseClass() != null) {
                this.client.setInBodyBindingFactory(BindingDirectory.getFactory((Class)request.getSeparateBodyResponseClass()));
            }
            if (null == (protocol = ProtocolDirectory.getProtocol((String)(soapVersion = request.getSoapVersion() != null ? request.getSoapVersion() : SoapVersion.SOAP1_1).toString()))) {
                throw new IllegalArgumentException("invalid soap version " + soapVersion.toString());
            }
            this.client.setProtocol(protocol);
            MessageOptions messageOptions = new MessageOptions();
            EnumSet<ContentEncoding> acceptEncoding = request.getAcceptEncoding();
            if (acceptEncoding != null && !acceptEncoding.isEmpty()) {
                String[] header = new String[acceptEncoding.size()];
                int i = 0;
                for (ContentEncoding contentEncoding : acceptEncoding) {
                    header[i++] = contentEncoding.name().toLowerCase();
                }
                messageOptions.setAcceptEncoding(header);
            }
            if ((acceptTypes = request.getAcceptTypes()) != null) {
                messageOptions.setInMediaTypeCodes(acceptTypes);
            }
            this.client.setMessageOptions(messageOptions);
            this.client.setOperationName(request.getAction());
            for (Object header : request.getHeaders()) {
                this.client.addOutHeader(header);
            }
            this.client.addInHeaderHandler((InHandler)new ResponseHeaderHandler(response, headerFactory));
            ArrayList<OutputStreamInterceptor> outputInterceptors = new ArrayList<OutputStreamInterceptor>();
            ArrayList<InputStreamInterceptor> inputInterceptors = new ArrayList<InputStreamInterceptor>();
            JiBXWSInvoker.addInterceptors(outputInterceptors, inputInterceptors, JiBXWSInvoker.getSecurityInterceptor(request.getSecurity(), soapVersion));
            this.loggingOutputHandler = new LoggingOutputHandler(createTransaction, url, request.getHttpHeaders(), request.getOutputFindReplacePair());
            this.loggingInputHandler = new LoggingInputHandler(createTransaction, url, this.loggingOutputHandler, request.getInputFindReplacePair());
            JiBXWSInvoker.addInterceptors(outputInterceptors, inputInterceptors, new Object[]{this.loggingInputHandler, this.loggingOutputHandler});
            HttpTransportOptions transportOptions = new HttpTransportOptions();
            Collections.reverse(outputInterceptors);
            transportOptions.setOutputStreamInterceptor((OutputStreamInterceptor)new OutputInterceptorsContainer(outputInterceptors));
            transportOptions.setInputStreamInterceptor((InputStreamInterceptor)new InputInterceptorsContainer(inputInterceptors));
            if (request.getConnectionTimeout() != null) {
                transportOptions.setConnectTimeout(request.getConnectionTimeout());
            } else {
                Integer defaultConnectionTimeout = Integer.getInteger("sun.net.client.defaultConnectTimeout");
                if (defaultConnectionTimeout != null) {
                    transportOptions.setConnectTimeout(defaultConnectionTimeout);
                }
            }
            if (request.getReadTimeout() != null) {
                transportOptions.setReadTimeout(request.getReadTimeout());
            } else {
                Integer defaultReadTimeout = Integer.getInteger("sun.net.client.defaultReadTimeout");
                if (defaultReadTimeout != null) {
                    transportOptions.setReadTimeout(defaultReadTimeout);
                }
            }
            if (request.isUseSsl()) {
                KeyStore keyStore = request.getKeyStore();
                char[] pswd = request.getKeyPassword();
                if (null == keyStore) {
                    keyStore = SecurityHelper.getInstance().getKeyStore();
                    pswd = DesUtil.decode((String)SecurityHelper.getInstance().getPassword()).toCharArray();
                }
                SSLContext sc = SSLContext.getInstance("TLS");
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, pswd);
                KeyManager[] keyManagers = kmf.getKeyManagers();
                sc.init(keyManagers, TRUST_MANAGERS, new SecureRandom());
                transportOptions.setSslContext(sc);
            }
            if (request.isUseTrustyHostnameVerifier()) {
                transportOptions.setSslHostnameVerifier(TRUSTFUL_HOSTNAME_VERIFIER);
            }
            transportOptions.setCredentials(request.getCredentials());
            this.client.setTransportOptions((TransportOptions)transportOptions);
        }

        public SoapClient getClient() {
            return this.client;
        }

        public LoggingOutputHandler getLoggingOutputHandler() {
            return this.loggingOutputHandler;
        }

        public LoggingInputHandler getLoggingInputHandler() {
            return this.loggingInputHandler;
        }
    }
}

