/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jibxws;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class WSSecurity {
    private final Signature signature = new Signature();
    private final Encryption encryption = new Encryption();
    private KeyStore keyStore;
    private KeyStore trustStore;
    private String keyStoreAlias;
    private char[] keyStorePswd;
    private String trustStoreAlias;
    private boolean useSingleCert = true;
    private ProtectionOrder protectionOrder = ProtectionOrder.SIGN_BEFORE_ENCRYPTING;
    private static final QName TAG_SOAP_BODY = new QName("", "Body", "soap");

    public Signature getSignature() {
        return this.signature;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public void setKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    public char[] getKeyStorePswd() {
        return this.keyStorePswd;
    }

    public void setKeyStorePswd(char[] keyStorePswd) {
        this.keyStorePswd = keyStorePswd;
    }

    public String getTrustStoreAlias() {
        return this.trustStoreAlias;
    }

    public void setTrustStoreAlias(String trustStoreAlias) {
        this.trustStoreAlias = trustStoreAlias;
    }

    public boolean isUseSingleCert() {
        return this.useSingleCert;
    }

    public void setUseSingleCert(boolean useSingleCert) {
        this.useSingleCert = useSingleCert;
    }

    public ProtectionOrder getProtectionOrder() {
        return this.protectionOrder;
    }

    public void setProtectionOrder(ProtectionOrder protectionOrder) {
        this.protectionOrder = protectionOrder;
    }

    public static enum Algorithm {
        HmacSha1("http://www.w3.org/2000/09/xmldsig#hmac-sha1"),
        RsaSha1("http://www.w3.org/2000/09/xmldsig#rsa-sha1"),
        Sha1("http://www.w3.org/2000/09/xmldsig#sha1"),
        Sha256("http://www.w3.org/2001/04/xmlenc#sha256"),
        Sha512("http://www.w3.org/2001/04/xmlenc#sha512"),
        Aes128("http://www.w3.org/2001/04/xmlenc#aes128-cbc"),
        Aes192("http://www.w3.org/2001/04/xmlenc#aes192-cbc"),
        Aes256("http://www.w3.org/2001/04/xmlenc#aes256-cbc"),
        TripleDes("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"),
        KwAes128("http://www.w3.org/2001/04/xmlenc#kw-aes128"),
        KwAes192("http://www.w3.org/2001/04/xmlenc#kw-aes192"),
        KwAes256("http://www.w3.org/2001/04/xmlenc#kw-aes256"),
        KwTripleDes("http://www.w3.org/2001/04/xmlenc#kw-tripledes"),
        KwRsaOaep("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"),
        KwRsa15("http://www.w3.org/2001/04/xmlenc#rsa-1_5"),
        PSha1("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1"),
        PSha1L128("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1"),
        PSha1L192("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1"),
        PSha1L256("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1"),
        XPath("http://www.w3.org/TR/1999/REC-xpath-19991116"),
        XPath20("http://www.w3.org/2002/06/xmldsig-filter2"),
        C14n("http://www.w3.org/2001/10/xml-c14n#"),
        ExC14n("http://www.w3.org/2001/10/xml-exc-c14n#"),
        SNT("http://www.w3.org/TR/soap12-n11n"),
        STRT10("http://docs.oasis-open.org/wss/2004/xx/oasis-2004xx-wss-soap-messagesecurity-1.0#STR-Transform"),
        AbsXPath("http://docs.oasis-open.org/...TBD.../AbsXPath");

        private final String id;

        private Algorithm(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum Modifier {
        ELEMENT,
        CONTENT;

    }

    public static class Part {
        private QName name;
        private Modifier modifier;

        public Part(QName name, Modifier modifier) {
            this.name = name;
            this.modifier = modifier;
        }

        public QName getName() {
            return this.name;
        }

        public Modifier getModifier() {
            return this.modifier;
        }
    }

    public static class Parts {
        private final List<Part> parts = new ArrayList<Part>();

        public void addElement(QName name) {
            this.parts.add(new Part(name, Modifier.ELEMENT));
        }

        public void addContent(QName name) {
            this.parts.add(new Part(name, Modifier.CONTENT));
        }

        public void addBodyElement() {
            this.parts.add(new Part(TAG_SOAP_BODY, Modifier.ELEMENT));
        }

        public void addBodyContent() {
            this.parts.add(new Part(TAG_SOAP_BODY, Modifier.CONTENT));
        }

        public List<Part> getParts() {
            return this.parts;
        }
    }

    public static class Encryption {
        private boolean includeToken;
        private Parts parts;
        private Algorithm symAlgorithm;
        private Algorithm keyTransportAlgorithm;

        public boolean isIncludeToken() {
            return this.includeToken;
        }

        public void setIncludeToken(boolean includeToken) {
            this.includeToken = includeToken;
        }

        public Parts getParts() {
            return this.parts;
        }

        public void setParts(Parts parts) {
            this.parts = parts;
        }

        public Algorithm getSymAlgorithm() {
            return this.symAlgorithm;
        }

        public void setSymAlgorithm(Algorithm symAlgorithm) {
            this.symAlgorithm = symAlgorithm;
        }

        public Algorithm getKeyTransportAlgorithm() {
            return this.keyTransportAlgorithm;
        }

        public void setKeyTransportAlgorithm(Algorithm keyTransportAlgorithm) {
            this.keyTransportAlgorithm = keyTransportAlgorithm;
        }
    }

    public static class Signature {
        private boolean includeToken;
        private Parts parts;
        private Algorithm canonicalizationAlgorithm;
        private Algorithm algorithm;
        private Algorithm digestAlgorithm;

        public boolean isIncludeToken() {
            return this.includeToken;
        }

        public void setIncludeToken(boolean includeToken) {
            this.includeToken = includeToken;
        }

        public Parts getParts() {
            return this.parts;
        }

        public void setParts(Parts parts) {
            this.parts = parts;
        }

        public Algorithm getCanonicalizationAlgorithm() {
            return this.canonicalizationAlgorithm;
        }

        public void setCanonicalizationAlgorithm(Algorithm canonicalizationAlgorithm) {
            this.canonicalizationAlgorithm = canonicalizationAlgorithm;
        }

        public Algorithm getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        public Algorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public void setDigestAlgorithm(Algorithm digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
        }
    }

    public static enum ProtectionOrder {
        ENCRYPT_BEFORE_SIGNING,
        SIGN_BEFORE_ENCRYPTING;

    }
}

