/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jibxws;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import java.util.HashSet;
import java.util.Map;

public class WsLogBookingFileAdvice
extends BaseAdvice {
    private String docName;

    public void configure(Map<String, String> params) throws Exception {
        this.docName = params.get("doc-name");
    }

    public void before(MessageContext ctx) throws Exception {
        ctx.putObject((Enum)IBusJibxWsContextKeys.ENABLE_LOG_DOCUMENT, (Object)Boolean.TRUE);
    }

    public void after(MessageContext ctx) throws Exception {
        Document doc = (Document)ctx.getObject((Enum)IBusJibxWsContextKeys.WS_LOG_DOCUMENT);
        String docNameSuffix = (String)ctx.getObject((Enum)IBusJibxWsContextKeys.LOG_DOCUMENT_NAME_SUFFIX);
        if (doc != null) {
            HashSet<Document> documents;
            EntityContainer gdsAccountCtr;
            String name = this.docName;
            if (TextUtil.nonBlank((String)docNameSuffix)) {
                name = name + docNameSuffix;
            }
            doc.setName(name + ".xml");
            doc.setTitle(name + " transactions");
            EntityContainer bfCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
            if (bfCtr != null) {
                doc.setOwner(bfCtr.toReference());
            }
            if ((gdsAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT)) != null) {
                doc.setTitle(doc.getTitle() + String.format(" (%s)", ((BaseGdsAccount)gdsAccountCtr.getEntity()).getName()));
            }
            if ((documents = (HashSet<Document>)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS)) == null) {
                documents = new HashSet<Document>();
                ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS, documents);
            }
            documents.add(doc);
        }
    }
}

