/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.jibxws;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.jibxws.ContentEncoding;
import com.gridnine.xtrip.server.jibxws.WSSecurity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jibx.ws.http.client.Credentials;
import org.jibx.ws.soap.SoapVersion;

public class WsRequest {
    private SoapVersion soapVersion;
    private String endpointAddress;
    private String action;
    private final List<Object> headers = new ArrayList<Object>();
    private final Map<String, String[]> httpHeaders = new HashMap<String, String[]>();
    private Object payload;
    private EnumSet<ContentEncoding> acceptEncoding = EnumSet.of(ContentEncoding.GZIP);
    private String[] acceptTypes = null;
    private Integer connectionTimeout;
    private Integer readTimeout;
    private boolean useSsl;
    private KeyStore keyStore;
    private char[] keyPassword;
    private boolean useTrustyHostnameVerifier;
    private Credentials credentials;
    private WSSecurity security;
    private Class separateBodyResponseClass;
    private MiscUtil.Pair<String, String> outputFindReplacePair;
    private MiscUtil.Pair<String, String> inputFindReplacePair;
    private boolean subclassExceptionsIncluded;
    private final List<Class<? extends Exception>> ignoredException = new ArrayList<Class<? extends Exception>>();

    public SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setEndpointAddress(String value) {
        this.endpointAddress = value;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public List<Object> getHeaders() {
        return this.headers;
    }

    public Map<String, String[]> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeader(String name, String value) {
        this.httpHeaders.put(name, new String[]{value});
    }

    public void addHttpHeader(String name, String value) {
        String[] values = this.httpHeaders.get(name);
        if (values != null) {
            values = Arrays.copyOf(values, values.length + 1);
            values[values.length - 1] = value;
            this.httpHeaders.put(name, values);
        } else {
            this.httpHeaders.put(name, new String[]{value});
        }
    }

    public void setHttpHeader(String name, String[] values) {
        if (values != null) {
            this.httpHeaders.put(name, values);
        } else {
            this.httpHeaders.remove(name);
        }
    }

    public void removeHttpHeader(String name) {
        this.httpHeaders.remove(name);
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object value) {
        this.payload = value;
    }

    public EnumSet<ContentEncoding> getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public void setAcceptEncoding(EnumSet<ContentEncoding> acceptEncodings) {
        this.acceptEncoding = acceptEncodings;
    }

    public String[] getAcceptTypes() {
        return this.acceptTypes;
    }

    public void setAcceptTypes(String[] acceptTypes) {
        this.acceptTypes = acceptTypes;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStore(byte[] keyStore, String format, char[] password) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore trustStore = KeyStore.getInstance(format);
        try (ByteArrayInputStream in = new ByteArrayInputStream(keyStore);){
            trustStore.load(in, password);
        }
        this.useSsl = true;
        this.keyStore = trustStore;
        this.keyPassword = password;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public boolean isUseTrustyHostnameVerifier() {
        return this.useTrustyHostnameVerifier;
    }

    public void setUseTrustyHostnameVerifier(boolean useTrustyHostnameVerifier) {
        this.useTrustyHostnameVerifier = useTrustyHostnameVerifier;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public WSSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(WSSecurity security) {
        this.security = security;
    }

    public Class getSeparateBodyResponseClass() {
        return this.separateBodyResponseClass;
    }

    public void setSeparateBodyResponseClass(Class separateBodyResponseClass) {
        this.separateBodyResponseClass = separateBodyResponseClass;
    }

    public MiscUtil.Pair<String, String> getOutputFindReplacePair() {
        return this.outputFindReplacePair;
    }

    public void setOutputFindReplacePair(MiscUtil.Pair<String, String> outputFindReplacePair) {
        this.outputFindReplacePair = outputFindReplacePair;
    }

    public MiscUtil.Pair<String, String> getInputFindReplacePair() {
        return this.inputFindReplacePair;
    }

    public void setInputFindReplacePair(MiscUtil.Pair<String, String> inputFindReplacePair) {
        this.inputFindReplacePair = inputFindReplacePair;
    }

    public boolean isSubclassExceptionsIncluded() {
        return this.subclassExceptionsIncluded;
    }

    public void setSubclassExceptionsIncluded(boolean subclassExceptionsIncluded) {
        this.subclassExceptionsIncluded = subclassExceptionsIncluded;
    }

    public List<Class<? extends Exception>> getIgnoredException() {
        return this.ignoredException;
    }
}

