/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.io.MarshallingPayloadWriter;
import org.jibx.ws.io.MessageOptions;
import org.jibx.ws.io.PayloadReader;
import org.jibx.ws.io.PayloadWriter;
import org.jibx.ws.io.UnmarshallingPayloadReader;
import org.jibx.ws.transport.Channel;
import org.jibx.ws.transport.Transport;
import org.jibx.ws.transport.TransportDirectory;
import org.jibx.ws.transport.TransportOptions;

public abstract class Client {
    private static final Log logger = LogFactory.getLog(Client.class);
    private Channel m_channel;
    private PayloadWriter m_bodyWriter;
    private PayloadReader m_bodyReader;
    private boolean m_modified;
    private MessageOptions m_messageOptions;
    private final String m_serviceLocation;
    private final Transport m_transport;
    private TransportOptions m_transportOptions;

    protected Client(String location) {
        if (location == null) {
            throw new NullPointerException("Service location must be non-null");
        }
        this.m_serviceLocation = location;
        this.m_transport = TransportDirectory.getTransport(this.m_serviceLocation);
    }

    public void setBindingFactory(IBindingFactory factory) throws WsBindingException {
        this.setOutBodyBindingFactory(factory);
        this.setInBodyBindingFactory(factory);
    }

    public final void setOutBodyBindingFactory(IBindingFactory factory) throws WsBindingException {
        this.setBodyWriter(new MarshallingPayloadWriter(factory));
    }

    private void setBodyWriter(PayloadWriter bodyWriter) {
        this.m_bodyWriter = bodyWriter;
        this.setModified(true);
    }

    public final void setMessageOptions(MessageOptions options) {
        try {
            this.closeChannel();
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to close existing channel", (Throwable)e);
        }
        this.m_messageOptions = new MessageOptions(options);
        this.setModified(true);
    }

    public void setTransportOptions(TransportOptions transportOptions) {
        this.m_transportOptions = transportOptions;
        this.setModified(true);
    }

    public final void setInBodyBindingFactory(IBindingFactory factory) throws WsBindingException {
        this.setBodyReader(new UnmarshallingPayloadReader(factory));
    }

    private void setBodyReader(PayloadReader bodyReader) {
        this.m_bodyReader = bodyReader;
        this.setModified(true);
    }

    public abstract Object call(Object var1) throws IOException, WsException;

    protected final boolean isModified() {
        return this.m_modified;
    }

    protected final void setModified(boolean modified) {
        this.m_modified = modified;
    }

    protected final Channel getChannel() throws WsConfigurationException {
        if (this.m_channel == null) {
            this.m_channel = this.m_transport.buildDuplexChannel(this.getServiceLocation(), this.getTransportOptions());
        }
        return this.m_channel;
    }

    protected final PayloadWriter getBodyWriter() {
        return this.m_bodyWriter;
    }

    protected final PayloadReader getBodyReader() {
        return this.m_bodyReader;
    }

    protected final MessageOptions getMessageOptions() {
        if (this.m_messageOptions == null) {
            this.m_messageOptions = new MessageOptions();
        }
        return this.m_messageOptions;
    }

    protected final TransportOptions getTransportOptions() {
        if (this.m_transportOptions == null) {
            this.m_transportOptions = this.m_transport.newTransportOptions();
        }
        return this.m_transportOptions;
    }

    protected final String getServiceLocation() {
        return this.m_serviceLocation;
    }

    public final void close() throws IOException {
        this.closeChannel();
    }

    private void closeChannel() throws IOException {
        if (this.m_channel != null) {
            this.m_channel.close();
            this.m_channel = null;
        }
    }
}

