/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.codec;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.EncodingCodec;

public class EncodingCodecCache {
    private static final String CODEC_PROPERTIES_PATH = "/encoding-codec.properties";
    private static final Map<String, EncodingCodec> m_codecMap = new HashMap<String, EncodingCodec>();

    public final EncodingCodec getCodec(String encoding) throws IOException {
        return m_codecMap.get(encoding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        InputStream in = CodecDirectory.class.getResourceAsStream(CODEC_PROPERTIES_PATH);
        if (in == null) {
            throw new RuntimeException("Unable to load required properties file '/encoding-codec.properties'");
        }
        try {
            Properties props = new Properties();
            props.load(in);
            for (Object item : props.keySet()) {
                String encoding = (String)item;
                String classname = props.getProperty(encoding);
                try {
                    Class<?> clazz = CodecDirectory.class.getClassLoader().loadClass(classname);
                    if (!EncodingCodec.class.isAssignableFrom(clazz)) throw new IllegalStateException("Class " + classname + ", specified for format '" + encoding + "', is not an org.jibx.ws.encoding.CodecFactory implementation");
                    m_codecMap.put(encoding.toLowerCase(), (EncodingCodec)clazz.newInstance());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to load encoding class " + classname);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Error creating an instance of encoding class " + classname);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unable to create an instance of encoding class " + classname);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load required properties file '/encoding-codec.properties'");
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

