/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.codec;

import java.io.IOException;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.IInByteBuffer;
import org.jibx.runtime.impl.IOutByteBuffer;
import org.jibx.runtime.impl.ISO88591StreamWriter;
import org.jibx.runtime.impl.IXMLReaderFactory;
import org.jibx.runtime.impl.InputStreamWrapper;
import org.jibx.runtime.impl.RuntimeSupport;
import org.jibx.runtime.impl.StreamWriterBase;
import org.jibx.runtime.impl.UTF8StreamWriter;
import org.jibx.ws.codec.CodecFactory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.codec.XmlCodec;

public final class TextCodecFactory
implements CodecFactory {
    private static final IXMLReaderFactory s_readerFactory = RuntimeSupport.loadFactory();

    public XmlCodec createInstance(MediaType mediatype) {
        return new TextCodec(mediatype);
    }

    public static final class TextCodec
    implements XmlCodec {
        public static final String DEFAULT_ENCODING = "UTF-8";
        private final MediaType m_mediaType;
        private StreamWriterBase m_writer;
        private InputStreamWrapper m_inWrapper;
        private IXMLReader m_reader;

        public TextCodec(MediaType mediaType) {
            this.m_mediaType = mediaType;
        }

        public MediaType getMediaType() {
            return this.m_mediaType;
        }

        public IXMLWriter getWriter(IOutByteBuffer buff, String charcode, String[] uris) throws IOException {
            if (this.m_writer != null && (charcode == null || charcode.equalsIgnoreCase(this.m_writer.getEncodingName()))) {
                this.m_writer.setNamespaceUris(uris);
            } else {
                if (charcode == null) {
                    charcode = DEFAULT_ENCODING;
                }
                if (DEFAULT_ENCODING.equalsIgnoreCase(charcode)) {
                    this.m_writer = new UTF8StreamWriter(uris);
                } else if ("ISO-8859-1".equalsIgnoreCase(charcode)) {
                    this.m_writer = new ISO88591StreamWriter(uris);
                } else {
                    throw new IllegalStateException("Unimplemented character encoding " + charcode);
                }
            }
            this.m_writer.setBuffer(buff);
            return this.m_writer;
        }

        public IXMLReader getReader(IInByteBuffer buff, String charcode, String name, boolean reset) throws IOException {
            if (this.m_inWrapper == null) {
                this.m_inWrapper = new InputStreamWrapper();
            }
            this.m_inWrapper.reset();
            this.m_inWrapper.setBuffer(buff);
            this.m_inWrapper.setEncoding(charcode);
            try {
                this.m_reader = this.m_reader == null ? s_readerFactory.createReader(this.m_inWrapper.getReader(), name, true) : s_readerFactory.recycleReader(this.m_reader, this.m_inWrapper.getReader(), name);
            }
            catch (JiBXException e) {
                throw new IOException("Error creating reader: " + e.getMessage());
            }
            return this.m_reader;
        }
    }
}

