/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.context;

import java.util.ArrayList;
import org.jibx.ws.context.Context;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.MessageContext;
import org.jibx.ws.context.OutContext;

public final class ExchangeContext
extends Context {
    private final ArrayList m_msgCtxs = new ArrayList();
    private int m_currMsgCtxIdx;

    public static ExchangeContext createInOnlyExchange(InContext inboundContext) {
        return new ExchangeContext(inboundContext);
    }

    public static ExchangeContext createOutOnlyExchange(OutContext outboundContext) {
        return new ExchangeContext(outboundContext);
    }

    public static ExchangeContext createOutInExchange(OutContext outboundContext, InContext inboundContext) {
        return new ExchangeContext(outboundContext, inboundContext);
    }

    public static ExchangeContext createInOutExchange(InContext inboundContext, OutContext outboundContext) {
        return new ExchangeContext(inboundContext, outboundContext);
    }

    private ExchangeContext(MessageContext context) {
        context.setExchangeContext(this);
        this.m_msgCtxs.add(context);
    }

    private ExchangeContext(MessageContext context1, MessageContext context2) {
        context1.setExchangeContext(this);
        this.m_msgCtxs.add(context1);
        context2.setExchangeContext(this);
        this.m_msgCtxs.add(context2);
    }

    public MessageContext getCurrentMessageContext() {
        return this.messageContextAt(this.m_currMsgCtxIdx);
    }

    public MessageContext getNextMessageContext() {
        return this.messageContextAt(this.m_currMsgCtxIdx + 1);
    }

    private MessageContext messageContextAt(int idx) {
        MessageContext messageContext = null;
        if (idx < this.m_msgCtxs.size()) {
            messageContext = (MessageContext)this.m_msgCtxs.get(idx);
        }
        return messageContext;
    }

    public void switchMessageContext() {
        ++this.m_currMsgCtxIdx;
    }

    public void reset() {
        super.reset();
        this.m_currMsgCtxIdx = 0;
        for (int i = 0; i < this.m_msgCtxs.size(); ++i) {
            ((MessageContext)this.m_msgCtxs.get(i)).reset();
        }
    }
}

