/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jibx.runtime.IXMLWriter;
import org.jibx.ws.WsException;
import org.jibx.ws.context.MessageContext;
import org.jibx.ws.context.Phase;
import org.jibx.ws.io.PayloadWriter;
import org.jibx.ws.io.handler.OutHandler;

public final class OutContext
extends MessageContext {
    private PayloadWriter m_bodyWriter;
    private Map m_handlersByPhase;

    public void setBodyWriter(PayloadWriter bodyWriter) {
        this.m_bodyWriter = bodyWriter;
    }

    public void invokeBodyWriter(IXMLWriter xmlWriter) throws IOException, WsException {
        if (this.m_bodyWriter != null) {
            this.m_bodyWriter.invoke(xmlWriter, this.getBody());
        }
    }

    public void addHandler(Phase phase, OutHandler handler) {
        if (handler != null) {
            ArrayList<OutHandler> handlers;
            if (this.m_handlersByPhase == null) {
                this.m_handlersByPhase = new HashMap();
            }
            if ((handlers = (ArrayList<OutHandler>)this.m_handlersByPhase.get(phase)) == null) {
                handlers = new ArrayList<OutHandler>();
                this.m_handlersByPhase.put(phase, handlers);
            }
            handlers.add(handler);
        }
    }

    public boolean hasHandlers(Phase phase) {
        if (this.m_handlersByPhase == null) {
            return false;
        }
        ArrayList handlers = (ArrayList)this.m_handlersByPhase.get(phase);
        return handlers != null && handlers.size() > 0;
    }

    public void invokeHandlers(Phase phase, IXMLWriter xmlWriter) throws IOException, WsException {
        ArrayList handlers;
        if (this.m_handlersByPhase != null && (handlers = (ArrayList)this.m_handlersByPhase.get(phase)) != null) {
            for (int i = 0; i < handlers.size(); ++i) {
                ((OutHandler)handlers.get(i)).invoke(this, xmlWriter);
            }
        }
    }

    public boolean isOutbound() {
        return true;
    }

    public void reset() {
        super.reset();
        this.m_bodyWriter.reset();
    }
}

