/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.IInByteBuffer;
import org.jibx.runtime.impl.IOutByteBuffer;
import org.jibx.runtime.impl.InByteBuffer;
import org.jibx.runtime.impl.OutByteBuffer;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.CodecPool;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.codec.XmlCodec;
import org.jibx.ws.http.servlet.HttpServletOptions;
import org.jibx.ws.http.servlet.ServiceMapper;
import org.jibx.ws.io.XmlOptions;
import org.jibx.ws.server.MediaTypeMapper;
import org.jibx.ws.server.Service;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.OutConnectionBase;
import org.jibx.ws.transport.OutServerConnection;
import org.jibx.ws.transport.StreamBufferInPool;
import org.jibx.ws.transport.StreamBufferOutPool;
import org.jibx.ws.transport.interceptor.InputStreamInterceptor;
import org.jibx.ws.transport.interceptor.OutputStreamInterceptor;
import org.jibx.ws.wsdl.WsdlProvider;

public final class WsServletDelegate {
    private static final int BUFFER_SIZE = 8192;
    private static final String CHARSET_KEY = "charset";
    private static final Log logger = LogFactory.getLog(WsServletDelegate.class);
    private static final CodecPool s_codecPool = new CodecPool();
    private static final StreamBufferInPool s_inBufferCache = new StreamBufferInPool(8192);
    private static final StreamBufferOutPool s_outBufferCache = new StreamBufferOutPool(8192);
    private ServiceMapper m_serviceMapper;

    void setServiceMapper(ServiceMapper mapper) {
        this.m_serviceMapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        CodecPool codecPool;
        logger.debug((Object)"Entered WsServletDelegate.doPost()");
        Service serv = null;
        XmlCodec incodec = null;
        XmlCodec outcodec = null;
        InByteBuffer inbuff = null;
        OutByteBuffer outbuff = null;
        try {
            try {
                serv = this.m_serviceMapper.getServiceInstance(req);
                if (serv == null) {
                    rsp.sendError(404);
                }
                MediaType intype = this.getMediaType(req.getContentType(), serv.getMediaTypeMapper());
                MediaType outtype = this.getAcceptableMediaType(req.getHeader("Accept"), intype);
                CodecPool codecPool2 = s_codecPool;
                synchronized (codecPool2) {
                    incodec = s_codecPool.getCodec(intype);
                    outcodec = intype.equals(outtype) ? incodec : s_codecPool.getCodec(outtype);
                    inbuff = (InByteBuffer)s_inBufferCache.getInstance();
                    outbuff = (OutByteBuffer)s_outBufferCache.getInstance();
                }
                InboundConnection inconn = new InboundConnection(req, incodec, inbuff);
                OutboundConnection outconn = new OutboundConnection(rsp, req.getCharacterEncoding(), serv.getXmlOptions(), outcodec, outbuff);
                HttpServletOptions options = (HttpServletOptions)serv.getTransportOptions(HttpServletOptions.class);
                if (options != null) {
                    if (options.getInputStreamInterceptor() != null) {
                        inconn.setInterceptor(options.getInputStreamInterceptor());
                    }
                    if (options.getOutputStreamInterceptor() != null) {
                        outconn.setInterceptor(options.getOutputStreamInterceptor());
                    }
                }
                serv.processRequest(inconn, outconn);
            }
            catch (WsException e) {
                logger.error((Object)"Error processing request", (Throwable)e);
                rsp.sendError(500, e.getMessage());
                Object var14_15 = null;
                CodecPool codecPool2 = s_codecPool;
                synchronized (codecPool2) {
                    if (serv != null) {
                        serv.releaseInstance();
                    }
                    if (incodec != null) {
                        s_codecPool.releaseCodec(incodec);
                    }
                    if (outcodec != null && outcodec != incodec) {
                        s_codecPool.releaseCodec(outcodec);
                    }
                    if (inbuff != null) {
                        s_inBufferCache.endUsage(inbuff);
                    }
                    if (outbuff == null) return;
                    s_outBufferCache.endUsage(outbuff);
                    return;
                }
            }
            Object var14_14 = null;
            codecPool = s_codecPool;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            CodecPool codecPool4 = s_codecPool;
            synchronized (codecPool4) {
                if (serv != null) {
                    serv.releaseInstance();
                }
                if (incodec != null) {
                    s_codecPool.releaseCodec(incodec);
                }
                if (outcodec != null && outcodec != incodec) {
                    s_codecPool.releaseCodec(outcodec);
                }
                if (inbuff != null) {
                    s_inBufferCache.endUsage(inbuff);
                }
                if (outbuff == null) throw throwable;
                s_outBufferCache.endUsage(outbuff);
                throw throwable;
            }
        }
        synchronized (codecPool) {
            if (serv != null) {
                serv.releaseInstance();
            }
            if (incodec != null) {
                s_codecPool.releaseCodec(incodec);
            }
            if (outcodec != null && outcodec != incodec) {
                s_codecPool.releaseCodec(outcodec);
            }
            if (inbuff != null) {
                s_inBufferCache.endUsage(inbuff);
            }
            if (outbuff == null) return;
            s_outBufferCache.endUsage(outbuff);
            return;
        }
    }

    private MediaType getMediaType(String mediastring, MediaTypeMapper mapper) throws ServletException {
        MediaType media;
        if (mediastring == null) {
            try {
                media = mapper.getMediaTypeFor(null);
            }
            catch (WsConfigurationException e) {
                throw new ServletException("Internal JiBX/WS error. Unable to find default media type due to '" + e.getMessage() + "'.");
            }
        }
        try {
            media = new MediaType(mediastring, true);
        }
        catch (ParseException e) {
            throw new ServletException("Error parsing media type in content-type from request: " + mediastring);
        }
        if (!CodecDirectory.hasCodecFor(media)) {
            throw new ServletException("No supported media type in content-type from request: " + mediastring);
        }
        return media;
    }

    private MediaType getAcceptableMediaType(String acceptable, MediaType contentType) throws ServletException {
        try {
            return CodecDirectory.getAcceptableMediaType(acceptable, contentType);
        }
        catch (ParseException e) {
            throw new ServletException("Error parsing media type in accept-type from request: " + acceptable, (Throwable)e);
        }
    }

    protected void doGet(ServletContext context, HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        block11: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Entered WsServletDelegate.doGet() with query string: " + req.getQueryString()));
            }
            if ("wsdl".equalsIgnoreCase(req.getQueryString())) {
                Service service = null;
                try {
                    block10: {
                        try {
                            logger.debug((Object)"Looking up service for WSDL");
                            service = this.m_serviceMapper.getServiceInstance(req);
                            if (service == null) {
                                logger.debug((Object)"Unable to find service for WSDL");
                                rsp.sendError(405);
                                break block10;
                            }
                            WsdlProvider wsdlProvider = service.getWsdlProvider();
                            if (wsdlProvider == null) {
                                logger.debug((Object)"Unable to WSDL provider for service");
                                rsp.sendError(405);
                                break block10;
                            }
                            logger.debug((Object)"Returning WSDL");
                            wsdlProvider.writeWSDL((OutputStream)rsp.getOutputStream(), req);
                        }
                        catch (WsException e) {
                            logger.error((Object)"Error creating WSDL", (Throwable)e);
                            throw new ServletException(e.getMessage(), (Throwable)e);
                        }
                    }
                    Object var7_7 = null;
                    if (service != null) {
                        service.releaseInstance();
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (service != null) {
                        service.releaseInstance();
                    }
                    throw throwable;
                }
            }
            rsp.sendError(405);
        }
    }

    private static class OutboundConnection
    extends OutConnectionBase
    implements OutServerConnection {
        private final HttpServletResponse m_response;
        private final XmlCodec m_codec;
        private final String m_characterCode;
        private OutByteBuffer m_buffer;
        private IXMLWriter m_writer;
        private OutputStreamInterceptor m_interceptor;

        public OutboundConnection(HttpServletResponse response, String charcode, XmlOptions xmlOptions, XmlCodec codec, OutByteBuffer buff) {
            super(xmlOptions);
            this.m_response = response;
            this.m_buffer = buff;
            this.m_codec = codec;
            this.m_characterCode = charcode;
        }

        public void sendNotFoundError() throws IOException {
            this.m_response.sendError(404);
        }

        public void setInternalServerError() {
            this.m_response.setStatus(500);
        }

        public boolean isCommitted() {
            return this.m_response.isCommitted();
        }

        public IXMLWriter getNormalWriter(String[] uris) throws IOException {
            if (this.m_writer == null) {
                MediaType contentType = this.m_codec.getMediaType();
                MediaType.Parameter charset = null;
                if (this.m_characterCode != null) {
                    charset = new MediaType.Parameter(WsServletDelegate.CHARSET_KEY, this.m_characterCode);
                }
                this.m_response.setContentType(contentType.toStringWithParams(new MediaType.Parameter[]{charset}));
                Object outputStream = this.m_response.getOutputStream();
                if (this.m_interceptor != null) {
                    outputStream = this.m_interceptor.intercept((OutputStream)outputStream);
                }
                this.m_buffer.setOutput((OutputStream)outputStream);
                this.m_writer = this.m_codec.getWriter((IOutByteBuffer)this.m_buffer, null, uris);
                this.initializeWriter(this.m_writer);
            }
            return this.m_writer;
        }

        public IXMLWriter getFaultWriter(String[] uris) throws IOException {
            return this.getNormalWriter(uris);
        }

        private void setInterceptor(OutputStreamInterceptor interceptor) {
            this.m_interceptor = interceptor;
        }

        public void outputComplete() {
            if (this.m_interceptor != null) {
                this.m_interceptor.outputComplete();
            }
        }

        public void close() throws IOException {
            logger.debug((Object)"Closing output connection");
            if (this.m_writer != null) {
                logger.debug((Object)"Closing writer");
                this.m_writer.close();
                this.m_writer.reset();
            }
        }
    }

    private static class InboundConnection
    implements InConnection {
        private final HttpServletRequest m_request;
        private final XmlCodec m_codec;
        private final InByteBuffer m_buffer;
        private IXMLReader m_reader;
        private InputStreamInterceptor m_interceptor;

        public InboundConnection(HttpServletRequest request, XmlCodec codec, InByteBuffer buff) {
            this.m_request = request;
            this.m_codec = codec;
            this.m_buffer = buff;
        }

        public String getCharacterEncoding() {
            return this.m_request.getCharacterEncoding();
        }

        public String getContentType() {
            return this.m_request.getContentType();
        }

        public String getDestination() {
            return null;
        }

        public String getId() {
            return null;
        }

        public String getOperationName() {
            return null;
        }

        public String getOrigin() {
            return this.m_request.getRemoteHost();
        }

        public String getProperty(String name) {
            return this.m_request.getHeader(name);
        }

        public IXMLReader getReader() throws IOException {
            if (this.m_reader == null) {
                Object inputStream = this.m_request.getInputStream();
                if (this.m_interceptor != null) {
                    inputStream = this.m_interceptor.intercept((InputStream)inputStream);
                }
                this.m_buffer.setInput((InputStream)inputStream);
                this.m_reader = this.m_codec.getReader((IInByteBuffer)this.m_buffer, this.m_request.getCharacterEncoding(), this.m_request.getRemoteAddr(), true);
            }
            return this.m_reader;
        }

        public void init() throws IOException {
            this.getReader();
            this.m_reader.init();
        }

        public boolean hasError() throws IOException {
            return false;
        }

        public String getErrorMessage() throws IOException {
            return null;
        }

        private void setInterceptor(InputStreamInterceptor interceptor) throws WsConfigurationException {
            this.m_interceptor = interceptor;
        }

        public void inputComplete() {
            if (this.m_interceptor != null) {
                this.m_interceptor.inputComplete();
            }
        }

        public void close() throws IOException {
            this.m_buffer.finish();
        }
    }
}

