/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.io;

import org.jibx.ws.io.XmlEncoding;
import org.jibx.ws.io.XmlOptions;

public final class MessageOptions {
    private static final String[] DEFAULT_INMEDIA_TYPE_CODES = new String[]{"xml"};
    private String m_outMediaTypeCode;
    private String[] m_inMediaTypeCodes;
    private String[] m_acceptEncoding;
    private XmlOptions m_xmlOptions;

    public MessageOptions() {
        this.m_xmlOptions = new XmlOptions();
        this.setOutMediaTypeCode("xml");
        this.setInMediaTypeCodes(DEFAULT_INMEDIA_TYPE_CODES);
    }

    public MessageOptions(MessageOptions options) {
        this.m_xmlOptions = new XmlOptions(options.getXmlOptions());
        this.setOutMediaTypeCode(options.getOutMediaTypeCode());
        this.setInMediaTypeCodes(options.getInMediaTypeCodes());
        this.setAcceptEncoding(options.getAcceptEncoding());
    }

    public MessageOptions(XmlEncoding encoding) {
        this();
        this.setEncoding(encoding);
    }

    public MessageOptions(XmlEncoding encoding, boolean includeEncodingDecl, Boolean standaloneDecl) {
        this(encoding);
        this.setIncludeEncodingDecl(includeEncodingDecl);
        this.setStandaloneDecl(standaloneDecl);
    }

    public MessageOptions(char indentChar, int indentCount, String newLine) {
        this();
        this.setIndentChar(indentChar);
        this.setIndentCount(indentCount);
        this.setNewLine(newLine);
    }

    public MessageOptions(XmlEncoding encoding, char indentChar, int indentCount, String newLine) {
        this(encoding);
        this.setIndentChar(indentChar);
        this.setIndentCount(indentCount);
        this.setNewLine(newLine);
    }

    public MessageOptions(XmlEncoding encoding, boolean includeEncodingDecl, Boolean standaloneDecl, char indentChar, int indentCount, String newLine) {
        this(encoding);
        this.setIncludeEncodingDecl(includeEncodingDecl);
        this.setStandaloneDecl(standaloneDecl);
        this.setIndentChar(indentChar);
        this.setIndentCount(indentCount);
        this.setNewLine(newLine);
    }

    public XmlEncoding getEncoding() {
        return this.m_xmlOptions.getEncoding();
    }

    public void setEncoding(XmlEncoding encoding) {
        this.m_xmlOptions.setEncoding(encoding);
    }

    public String getOutMediaTypeCode() {
        return this.m_outMediaTypeCode;
    }

    public void setOutMediaTypeCode(String code) {
        this.m_outMediaTypeCode = code;
    }

    public String[] getInMediaTypeCodes() {
        return this.m_inMediaTypeCodes;
    }

    public void setInMediaTypeCodes(String[] codes) {
        this.m_inMediaTypeCodes = new String[codes.length];
        System.arraycopy(codes, 0, this.m_inMediaTypeCodes, 0, codes.length);
    }

    public String[] getAcceptEncoding() {
        return this.m_acceptEncoding;
    }

    public void setAcceptEncoding(String[] encodings) {
        if (null == encodings) {
            this.m_acceptEncoding = null;
            return;
        }
        this.m_acceptEncoding = new String[encodings.length];
        System.arraycopy(encodings, 0, this.m_acceptEncoding, 0, encodings.length);
    }

    public int getIndentCount() {
        return this.m_xmlOptions.getIndentCount();
    }

    public void setIndentCount(int indentCount) {
        this.m_xmlOptions.setIndentCount(indentCount);
    }

    public char getIndentChar() {
        return this.m_xmlOptions.getIndentChar();
    }

    public void setIndentChar(char indentChar) {
        this.m_xmlOptions.setIndentChar(indentChar);
    }

    public String getNewLine() {
        return this.m_xmlOptions.getNewLine();
    }

    public void setNewLine(String newLine) {
        this.m_xmlOptions.setNewLine(newLine);
    }

    public Boolean getStandaloneDecl() {
        return this.m_xmlOptions.getStandaloneDecl();
    }

    public void setStandaloneDecl(Boolean standaloneDecl) {
        this.m_xmlOptions.setStandaloneDecl(standaloneDecl);
    }

    public boolean isIncludeEncodingDecl() {
        return this.m_xmlOptions.isIncludeEncodingDecl();
    }

    public void setIncludeEncodingDecl(boolean includeEncodingDecl) {
        this.m_xmlOptions.setIncludeEncodingDecl(includeEncodingDecl);
    }

    public String getEncodingDeclString() {
        return this.m_xmlOptions.getEncodingDeclString();
    }

    public String getStandaloneDeclString() {
        return this.m_xmlOptions.getStandaloneDeclString();
    }

    public XmlOptions getXmlOptions() {
        return this.m_xmlOptions;
    }
}

