/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.io;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.IXMLReaderFactory;

public final class XmlReaderWrapper {
    private static final IXMLReaderFactory s_readerFactory;
    private IXMLReader m_reader;

    private XmlReaderWrapper(IXMLReader reader) {
        this.m_reader = reader;
    }

    private static IXMLReaderFactory createReaderFactory(String cname) {
        Class<?> clas = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                clas = loader.loadClass(cname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clas == null) {
            try {
                loader = IUnmarshallingContext.class.getClassLoader();
                clas = loader.loadClass(cname);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to specified parser factory class " + cname);
            }
        }
        if (!IXMLReaderFactory.class.isAssignableFrom(clas)) {
            throw new RuntimeException("Specified parser factory class " + cname + " does not implement IXMLReaderFactory interface");
        }
        try {
            Method meth = clas.getMethod("getInstance", null);
            return (IXMLReaderFactory)meth.invoke(null, null);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Specified parser factory class " + cname + " does not define static getInstance() method");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error on parser factory class " + cname + " getInstance() method call: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error on parser factory class " + cname + " getInstance() method call: " + e.getMessage());
        }
    }

    public static IXMLReaderFactory getFactory() {
        return s_readerFactory;
    }

    public static XmlReaderWrapper createXmlReaderWrapper(InputStream ins, String enc) throws JiBXException {
        return new XmlReaderWrapper(s_readerFactory.createReader(ins, null, enc, true));
    }

    public static XmlReaderWrapper createXmlReaderWrapper(IXMLReader reader) {
        return new XmlReaderWrapper(reader);
    }

    public static String buildNameString(String ns, String name) {
        if (ns == null || "".equals(ns)) {
            return "\"" + name + "\"";
        }
        return "\"{" + ns + "}" + name + "\"";
    }

    public String currentNameString() {
        return XmlReaderWrapper.buildNameString(this.m_reader.getNamespace(), this.m_reader.getName());
    }

    public String buildPositionString() {
        return this.m_reader.buildPositionString();
    }

    public boolean verifyNamespace(String ns) {
        if (ns == null || "".equals(ns)) {
            return this.m_reader.getNamespace().length() == 0;
        }
        return ns.equals(this.m_reader.getNamespace());
    }

    public String toStart() throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            return this.m_reader.getName();
        }
        while (true) {
            switch (this.m_reader.next()) {
                case 2: {
                    return this.m_reader.getName();
                }
                case 3: {
                    throw new JiBXException("Expected start tag, found end tag " + this.currentNameString() + " " + this.buildPositionString());
                }
                case 1: {
                    throw new JiBXException("Expected start tag, found end of document " + this.buildPositionString());
                }
            }
        }
    }

    public String toEnd() throws JiBXException {
        if (this.m_reader.getEventType() == 3) {
            return this.m_reader.getName();
        }
        while (true) {
            switch (this.m_reader.next()) {
                case 2: {
                    throw new JiBXException("Expected end tag, found start tag " + this.currentNameString() + " " + this.buildPositionString());
                }
                case 3: {
                    return this.m_reader.getName();
                }
                case 1: {
                    throw new JiBXException("Expected end tag, found end of document " + this.buildPositionString());
                }
            }
        }
    }

    public int toTag() throws JiBXException {
        int type = this.m_reader.getEventType();
        while (type != 2 && type != 3) {
            if (type == 1) {
                throw new JiBXException("Expected tag, found end of document " + this.buildPositionString());
            }
            type = this.m_reader.next();
        }
        return type;
    }

    public boolean isAtStart(String ns, String name) throws JiBXException {
        return this.toTag() == 2 && this.m_reader.getName().equals(name) && this.verifyNamespace(ns);
    }

    public boolean isAtEnd(String ns, String name) throws JiBXException {
        return this.toTag() == 3 && this.m_reader.getName().equals(name) && this.verifyNamespace(ns);
    }

    public void parseToStartTag(String ns, String name) throws JiBXException {
        if (this.toTag() == 2) {
            if (!this.m_reader.getName().equals(name) || !this.verifyNamespace(ns)) {
                throw new JiBXException("Expected " + XmlReaderWrapper.buildNameString(ns, name) + " start tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
            }
        } else {
            throw new JiBXException("Expected " + XmlReaderWrapper.buildNameString(ns, name) + " start tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
        }
    }

    public void parsePastStartTag(String ns, String name) throws JiBXException {
        this.parseToStartTag(ns, name);
        this.m_reader.nextToken();
    }

    public boolean parseIfStartTag(String ns, String name) throws JiBXException {
        if (this.isAtStart(ns, name)) {
            this.m_reader.nextToken();
            return true;
        }
        return false;
    }

    public void parsePastCurrentEndTag(String ns, String name) throws JiBXException {
        if (this.toTag() == 3) {
            if (!this.m_reader.getName().equals(name) || !this.verifyNamespace(ns)) {
                throw new JiBXException("Expected " + XmlReaderWrapper.buildNameString(ns, name) + " end tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
            }
        } else {
            throw new JiBXException("Expected " + XmlReaderWrapper.buildNameString(ns, name) + " end tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
        }
        this.m_reader.nextToken();
    }

    public void parsePastEndTag(String ns, String name) throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            this.m_reader.nextToken();
        }
        this.parsePastCurrentEndTag(ns, name);
    }

    public void skipPastEndTag(String ns, String name) throws JiBXException {
        boolean found = false;
        while (!found) {
            if (this.toTag() == 3 && this.m_reader.getName().equals(name) && this.verifyNamespace(ns)) {
                found = true;
            }
            this.m_reader.nextToken();
        }
    }

    public boolean isStart() throws JiBXException {
        return this.toTag() == 2;
    }

    public boolean isEnd() throws JiBXException {
        return this.toTag() == 3;
    }

    public void skipCurrent() throws JiBXException {
        if (this.m_reader.getEventType() != 3) {
            int depth = 1;
            while (depth > 0) {
                int event = this.m_reader.next();
                if (event == 3) {
                    --depth;
                    continue;
                }
                if (event != 2) continue;
                ++depth;
            }
        }
        this.m_reader.nextToken();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String accumulateText() throws JiBXException {
        String text = null;
        StringBuffer buff = null;
        block5: while (true) {
            switch (this.m_reader.getEventType()) {
                case 6: {
                    if (this.m_reader.getText() == null) {
                        throw new JiBXException("Unexpanded entity reference in text at " + this.buildPositionString());
                    }
                }
                case 4: 
                case 5: {
                    if (text == null) {
                        text = this.m_reader.getText();
                        break;
                    }
                    if (buff == null) {
                        buff = new StringBuffer(text);
                    }
                    buff.append(this.m_reader.getText());
                    break;
                }
                case 2: 
                case 3: {
                    break block5;
                }
            }
            this.m_reader.nextToken();
        }
        if (buff != null) return buff.toString();
        if (text == null) {
            return "";
        }
        String string = text;
        return string;
    }

    public IXMLReader getReader() {
        return this.m_reader;
    }

    public void throwEndTagNameError(String ns, String name) throws JiBXException {
        throw new JiBXException("Expected " + XmlReaderWrapper.buildNameString(ns, name) + " end tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
    }

    public String parseContentText(String ns, String tag) throws JiBXException {
        String text = this.accumulateText();
        switch (this.m_reader.getEventType()) {
            case 3: {
                if (this.m_reader.getName().equals(tag) && this.verifyNamespace(ns)) {
                    this.m_reader.nextToken();
                    return text;
                }
                this.throwEndTagNameError(ns, tag);
            }
            case 2: {
                throw new JiBXException("Expected " + XmlReaderWrapper.buildNameString(ns, tag) + " end tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
            }
            case 1: {
                throw new JiBXException("Expected " + XmlReaderWrapper.buildNameString(ns, tag) + " end tag, found end of document " + this.buildPositionString());
            }
        }
        return null;
    }

    public String parseElementText(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentText(ns, tag);
    }

    public String getAttributeValue(String ns, String name) throws JiBXException {
        return this.m_reader.getAttributeValue(ns, name);
    }

    static {
        String prop = System.getProperty("org.jibx.runtime.impl.parser");
        if (prop == null) {
            IXMLReaderFactory fact = null;
            try {
                fact = XmlReaderWrapper.createReaderFactory("org.jibx.runtime.impl.XMLPullReaderFactory");
            }
            catch (Throwable e) {
                fact = XmlReaderWrapper.createReaderFactory("org.jibx.runtime.impl.StAXReaderFactory");
            }
            s_readerFactory = fact;
        } else {
            s_readerFactory = XmlReaderWrapper.createReaderFactory(prop);
        }
    }
}

