/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.io.handler;

import java.io.IOException;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IXMLWriter;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.io.MarshallingPayloadWriter;
import org.jibx.ws.io.handler.OutHandler;

public final class ContextAttributeMarshallingOutHandler
implements OutHandler {
    private final MarshallingPayloadWriter m_marshaller;
    private final String m_attributeName;

    public ContextAttributeMarshallingOutHandler(Class clazz, String attributeName) throws WsBindingException {
        this.m_marshaller = new MarshallingPayloadWriter(clazz);
        this.m_attributeName = attributeName;
    }

    public ContextAttributeMarshallingOutHandler(String className, String attributeName) throws WsBindingException, WsConfigurationException {
        try {
            Class<?> clazz = Class.forName(className);
            this.m_marshaller = new MarshallingPayloadWriter(clazz);
            this.m_attributeName = attributeName;
        }
        catch (ClassNotFoundException e) {
            throw new WsConfigurationException("Unable to create ContextualPayloadMarshaller.  Class not found: " + className);
        }
    }

    public ContextAttributeMarshallingOutHandler(String bindingName, String packageName, String attributeName) throws WsBindingException {
        this.m_marshaller = new MarshallingPayloadWriter(bindingName, packageName);
        this.m_attributeName = attributeName;
    }

    public ContextAttributeMarshallingOutHandler(IBindingFactory factory, String attributeName) throws WsBindingException {
        this.m_marshaller = new MarshallingPayloadWriter(factory);
        this.m_attributeName = attributeName;
    }

    public void invoke(OutContext context, IXMLWriter xmlWriter) throws IOException, WsException {
        Object payload = context.getAttribute(this.m_attributeName);
        if (payload == null) {
            throw new WsException("Unable to write header data since attribute " + this.m_attributeName + " is null in OutContext");
        }
        this.m_marshaller.invoke(xmlWriter, payload);
    }
}

