/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.MessageContext;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.process.Processor;
import org.jibx.ws.server.OperationDefinition;

public final class Operation {
    private final Method m_method;
    private final Class m_inputClass;
    private final Class m_outputClass;
    private final ParamIndices m_idxs;

    public static Operation newInstance(Class serviceClass, OperationDefinition opdef) throws WsConfigurationException {
        String methodName = opdef.getMethodName();
        if (methodName == null) {
            throw new IllegalArgumentException("Method Name must be set on operation definition");
        }
        Method[] methods = serviceClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method;
            ParamIndices idxs;
            if (!methodName.equals(methods[i].getName()) || (idxs = Operation.matchSignature(method = methods[i], opdef.getInputClassName(), opdef.getOutputClassName())) == null) continue;
            return new Operation(opdef, method, idxs);
        }
        throw new WsConfigurationException("Method " + methodName + " not found in " + serviceClass.getName() + " with expected signature");
    }

    private Operation(OperationDefinition opdef, Method method, ParamIndices idxs) {
        this.m_method = method;
        this.m_idxs = idxs;
        Class<?>[] params = method.getParameterTypes();
        this.m_inputClass = params.length == 0 ? null : params[0];
        Class<?> result = method.getReturnType();
        this.m_outputClass = result == Void.TYPE ? null : result;
    }

    public Object invoke(Object serviceObj, Object payload, Processor processor) throws InvocationTargetException, WsException {
        Object[] args = null;
        if (this.m_idxs.m_paramCount > 0) {
            args = new Object[this.m_idxs.m_paramCount];
            if (this.m_idxs.m_payloadIndex != -1) {
                args[((ParamIndices)this.m_idxs).m_payloadIndex] = payload;
            }
            if (this.m_idxs.m_inContextIndex != -1) {
                MessageContext currentContext = processor.getCurrentMessageContext();
                if (!(currentContext instanceof InContext)) {
                    throw new WsException("Error - attempt to invoke operation when current context is not an InContext");
                }
                args[((ParamIndices)this.m_idxs).m_inContextIndex] = currentContext;
            }
            if (this.m_idxs.m_outContextIndex != -1) {
                MessageContext nextContext = processor.getNextMessageContext();
                if (!(nextContext instanceof OutContext)) {
                    throw new WsException("Error - attempt to invoke 2-way operation when next message context is not an OutContext");
                }
                args[((ParamIndices)this.m_idxs).m_outContextIndex] = nextContext;
            }
        }
        try {
            return this.m_method.invoke(serviceObj, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Operation does not have access to method that was visible on construction - " + e.getMessage());
        }
    }

    private static ParamIndices matchSignature(Method method, String inputClassName, String outputClassName) {
        ParamIndices idxs = new ParamIndices();
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 0) {
            if (inputClassName != null) {
                return null;
            }
        } else {
            if (inputClassName != null && !inputClassName.equals(params[0].getName())) {
                return null;
            }
            idxs.m_payloadIndex = 0;
            if (params.length > 1) {
                if (params[1] != InContext.class) {
                    return null;
                }
                idxs.m_inContextIndex = 1;
                if (params.length > 2) {
                    if (params[2] != OutContext.class) {
                        return null;
                    }
                    idxs.m_outContextIndex = 2;
                    if (params.length > 3) {
                        return null;
                    }
                }
            }
        }
        if (outputClassName != null && !outputClassName.equals(method.getReturnType().getName())) {
            return null;
        }
        idxs.m_paramCount = params.length;
        return idxs;
    }

    public Class getInputClass() {
        return this.m_inputClass;
    }

    public Class getOutputClass() {
        return this.m_outputClass;
    }

    public boolean isStaticMethod() {
        int mods = this.m_method.getModifiers();
        return Modifier.isStatic(mods);
    }

    public String toString() {
        return this.m_method.toString();
    }

    private static final class ParamIndices {
        private int m_paramCount;
        private int m_payloadIndex = -1;
        private int m_inContextIndex = -1;
        private int m_outContextIndex = -1;

        private ParamIndices() {
        }
    }
}

