/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.server;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.JiBXException;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.io.MarshallingPayloadWriter;
import org.jibx.ws.io.UnmarshallingPayloadReader;
import org.jibx.ws.io.XmlOptions;
import org.jibx.ws.process.Processor;
import org.jibx.ws.server.MediaTypeMapper;
import org.jibx.ws.server.Operation;
import org.jibx.ws.server.OperationDefinition;
import org.jibx.ws.server.ServiceDefinition;
import org.jibx.ws.server.ServiceExceptionHandler;
import org.jibx.ws.server.ServiceExceptionHandlerFactory;
import org.jibx.ws.server.TransportOptions;
import org.jibx.ws.server.TransportOptionsDefinition;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.OutServerConnection;
import org.jibx.ws.transport.OutputCompletionEvent;
import org.jibx.ws.transport.OutputCompletionListener;
import org.jibx.ws.util.ExpandingPool;
import org.jibx.ws.wsdl.InputStreamWsdlProvider;
import org.jibx.ws.wsdl.WsdlLocationToRequestUrlAdapter;
import org.jibx.ws.wsdl.WsdlProvider;

public abstract class Service {
    private static final Log logger = LogFactory.getLog(Service.class);
    private final Object m_serviceObj;
    private final ServiceExceptionHandler m_serviceExceptionHandler;
    private ExpandingPool m_owningPool;
    private final Map m_operationByBodyMap;
    private IBindingFactory m_outBodyBindingFactory;
    private IBindingFactory m_inBodyBindingFactory;
    private final XmlOptions m_xmlOptions;
    private OutputCompletionListener m_outputCompletionListener;
    private Map m_transportOptionsMap = Collections.EMPTY_MAP;
    private final Processor m_processor;
    private final MediaTypeMapper m_mediaTypeMapper;

    public Service(ServiceDefinition sdef, Processor processor, MediaTypeMapper mediaTypeMapper, ServiceExceptionHandlerFactory defaultExceptionHandlerFactory) throws WsException {
        try {
            this.m_processor = processor;
            this.m_mediaTypeMapper = mediaTypeMapper;
            this.m_operationByBodyMap = new HashMap();
            Class clas = null;
            boolean hasInputs = false;
            boolean hasOutputs = false;
            for (int i = 0; i < sdef.getOperationDefinitions().size(); ++i) {
                OperationDefinition odef = (OperationDefinition)sdef.getOperationDefinitions().get(i);
                Operation op = Operation.newInstance(sdef.getServiceClass(), odef);
                String iname = "";
                if (op.getInputClass() != null) {
                    clas = op.getInputClass();
                    iname = clas.getName();
                    hasInputs = true;
                } else if (clas == null && op.getOutputClass() != null) {
                    clas = op.getOutputClass();
                    hasOutputs = true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding operation '" + op.toString() + "' to service map with key '" + iname + "'"));
                }
                this.m_operationByBodyMap.put(iname, op);
            }
            if (sdef.getServiceObject() != null) {
                this.m_serviceObj = sdef.getServiceObject();
            } else {
                boolean hasInstanceMethod = false;
                for (Operation operation : this.m_operationByBodyMap.values()) {
                    if (operation.isStaticMethod()) continue;
                    hasInstanceMethod = true;
                    break;
                }
                this.m_serviceObj = hasInstanceMethod ? sdef.getServiceClass().newInstance() : null;
            }
            this.m_serviceExceptionHandler = sdef.getServiceExceptionHandlerObject() != null ? sdef.getServiceExceptionHandlerObject() : (sdef.getServiceExceptionHandlerClass() != null ? (ServiceExceptionHandler)sdef.getServiceExceptionHandlerClass().newInstance() : defaultExceptionHandlerFactory.createServiceExceptionHandler());
            this.m_outBodyBindingFactory = sdef.getOutBodyBindingFactory();
            this.m_inBodyBindingFactory = sdef.getInBodyBindingFactory();
            if (this.m_outBodyBindingFactory == null && this.m_inBodyBindingFactory == null && clas != null) {
                try {
                    this.m_inBodyBindingFactory = this.m_outBodyBindingFactory = BindingDirectory.getFactory((Class)clas);
                }
                catch (JiBXException e) {
                    throw new WsConfigurationException("Unable to create service since bindings not compiled for class " + clas.getName(), e);
                }
            }
            if (hasInputs && this.m_inBodyBindingFactory == null) {
                throw new WsConfigurationException("Binding factories must be defined for body of inbound messages");
            }
            if (hasOutputs && this.m_outBodyBindingFactory == null) {
                throw new WsConfigurationException("Binding factories must be defined for body of outbound messages");
            }
            if (sdef.getOutputCompletionListenerObject() != null) {
                this.m_outputCompletionListener = sdef.getOutputCompletionListenerObject();
            } else if (sdef.getOutputCompletionListenerClass() != null) {
                this.m_outputCompletionListener = (OutputCompletionListener)sdef.getOutputCompletionListenerClass().newInstance();
            }
            this.m_xmlOptions = sdef.getXmlOptions();
            Collection transportOptionsDefinitions = sdef.getTransportOptionsDefinitions();
            if (transportOptionsDefinitions.size() > 0) {
                this.m_transportOptionsMap = new HashMap();
                for (TransportOptionsDefinition def : transportOptionsDefinitions) {
                    TransportOptions transportOptions = def.createTransportOptions();
                    this.m_transportOptionsMap.put(transportOptions.getClass().getName(), transportOptions);
                }
            }
            try {
                if (sdef.getWsdlFilepath() != null) {
                    InputStream wsdlStream = Service.class.getResourceAsStream(sdef.getWsdlFilepath());
                    if (wsdlStream == null) {
                        throw new WsConfigurationException("Unable to open WSDL file '" + sdef.getWsdlFilepath() + "'");
                    }
                    WsdlProvider wsdlProvider = new InputStreamWsdlProvider(wsdlStream);
                    if (sdef.getWsdlLocationTransform()) {
                        wsdlProvider = new WsdlLocationToRequestUrlAdapter(wsdlProvider);
                    }
                    this.setWsdlProvider(wsdlProvider);
                }
            }
            catch (IOException e) {
                throw new WsConfigurationException("Error reading WSDL file '" + sdef.getWsdlFilepath() + "'");
            }
        }
        catch (InstantiationException e) {
            throw new WsException("Error creating endpoint service object", e);
        }
        catch (IllegalAccessException e) {
            throw new WsException("Unable to create endpoint service object", e);
        }
    }

    final void setOwningPool(ExpandingPool pool) {
        this.m_owningPool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInstance() {
        ExpandingPool expandingPool = this.m_owningPool;
        synchronized (expandingPool) {
            this.m_owningPool.releaseInstance(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processRequest(InConnection iconn, OutServerConnection oconn) {
        OutContext outCtx = null;
        try {
            this.getProcessor().receiveMessage(iconn);
            Object body = this.getProcessor().getCurrentMessageContext().getBody();
            try {
                Object response = this.invokeOperation(body);
                this.getProcessor().switchMessageContext();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending response " + response));
                }
                outCtx = (OutContext)this.getProcessor().getCurrentMessageContext();
                outCtx.setBody(response);
                this.getProcessor().sendMessage(oconn);
            }
            catch (NoSuchMethodException e) {
                oconn.sendNotFoundError();
            }
        }
        catch (Throwable e) {
            if (oconn.isCommitted()) {
                logger.error((Object)"Aborted response due to error after commit", e);
            } else {
                this.getProcessor().switchMessageContext();
                outCtx = (OutContext)this.getProcessor().getCurrentMessageContext();
                this.getServiceExceptionHandler().handleException(e, this.getProcessor(), oconn);
            }
        }
        finally {
            try {
                if (this.m_outputCompletionListener != null && outCtx != null) {
                    logger.debug((Object)"Calling output completion listener");
                    this.m_outputCompletionListener.onComplete(new OutputCompletionEvent(outCtx));
                }
            }
            finally {
                this.getProcessor().reset();
            }
        }
    }

    private Object invokeOperation(Object payload) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, WsException {
        Operation op = this.getOperation(payload);
        if (op == null) {
            throw new NoSuchMethodException("No operation defined for payload type " + payload == null ? "null" : payload.getClass().getName());
        }
        return op.invoke(this.m_serviceObj, payload, this.getProcessor());
    }

    private Operation getOperation(Object body) {
        String cname = "";
        if (body != null) {
            cname = body.getClass().getName();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for operation mapped by class name '" + cname + "'"));
        }
        return (Operation)this.m_operationByBodyMap.get(cname);
    }

    public final IBindingFactory getOutBodyBindingFactory() {
        return this.m_outBodyBindingFactory;
    }

    public final IBindingFactory getInBodyBindingFactory() {
        return this.m_inBodyBindingFactory;
    }

    public final Collection getOperations() {
        return Collections.unmodifiableCollection(this.m_operationByBodyMap.values());
    }

    protected ServiceExceptionHandler getServiceExceptionHandler() {
        return this.m_serviceExceptionHandler;
    }

    protected void createBodyHandlers(InContext inCtx, OutContext outCtx) throws WsBindingException {
        IBindingFactory inBodyBindingFactory;
        IBindingFactory outBodyBindingFactory = this.getOutBodyBindingFactory();
        if (outBodyBindingFactory != null) {
            outCtx.setBodyWriter(new MarshallingPayloadWriter(outBodyBindingFactory));
        }
        if ((inBodyBindingFactory = this.getInBodyBindingFactory()) != null) {
            inCtx.setBodyReader(new UnmarshallingPayloadReader(inBodyBindingFactory));
        }
    }

    protected void setContextOnTransportOptions(InContext inCtx, OutContext outCtx) {
        for (TransportOptions options : this.m_transportOptionsMap.values()) {
            options.setMessageContexts(inCtx, outCtx);
        }
    }

    protected Processor getProcessor() {
        return this.m_processor;
    }

    public XmlOptions getXmlOptions() {
        return this.m_xmlOptions;
    }

    public TransportOptions getTransportOptions(Class optionsClass) {
        return (TransportOptions)this.m_transportOptionsMap.get(optionsClass.getName());
    }

    public MediaTypeMapper getMediaTypeMapper() {
        return this.m_mediaTypeMapper;
    }

    public abstract void setWsdlProvider(WsdlProvider var1);

    public abstract WsdlProvider getWsdlProvider();
}

