/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.IOException;
import org.jibx.runtime.IBindingFactory;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.client.Client;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.context.ExchangeContext;
import org.jibx.ws.io.MessageOptions;
import org.jibx.ws.process.Processor;
import org.jibx.ws.server.MediaTypeMapper;
import org.jibx.ws.server.Service;
import org.jibx.ws.server.ServiceDefinition;
import org.jibx.ws.server.ServiceExceptionHandler;
import org.jibx.ws.server.ServiceExceptionHandlerFactory;
import org.jibx.ws.server.ServiceFactory;
import org.jibx.ws.soap.SoapProcessor11;
import org.jibx.ws.soap.SoapProtocol;
import org.jibx.ws.soap.SoapVersion;
import org.jibx.ws.soap.client.SoapClient;
import org.jibx.ws.soap.server.SoapFaultHandler;
import org.jibx.ws.soap.server.SoapService;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.MessageProperties;

final class SoapProtocol11
extends SoapProtocol {
    private static final String SOAP_ACTION_HEADER = "SOAPAction";
    private static final MediaTypeMapper s_soap11MediaTypeMapper;
    private static final ServiceExceptionHandlerFactory s_exceptionHandlerFactoryWithTrace11;
    private static final ServiceExceptionHandlerFactory s_exceptionHandlerFactoryNoTrace11;
    private static final ServiceFactory s_service11Factory;

    SoapProtocol11() {
    }

    private static ServiceExceptionHandlerFactory getDefaultExceptionHandlerFactory(boolean includeStackTrace) {
        if (includeStackTrace) {
            return s_exceptionHandlerFactoryWithTrace11;
        }
        return s_exceptionHandlerFactoryNoTrace11;
    }

    public SoapVersion getSoapVersion() {
        return SoapVersion.SOAP1_1;
    }

    public Processor createProcessor() {
        return new SoapProcessor11();
    }

    public Processor createProcessor(ExchangeContext exchangeContext) {
        return new SoapProcessor11(exchangeContext);
    }

    public Client createClient(String location, IBindingFactory factory, MessageOptions options) throws WsBindingException, WsConfigurationException {
        return new SoapClient(location, factory, options, this);
    }

    public ServiceFactory getServiceFactory() {
        return s_service11Factory;
    }

    public MediaTypeMapper getMediaTypeMapper() {
        return s_soap11MediaTypeMapper;
    }

    public MessageProperties buildMessageProperties(String opname, MessageOptions msgOptions) throws WsConfigurationException {
        String charset = msgOptions.getEncoding().toString();
        String outtype = msgOptions.getOutMediaTypeCode();
        String[] intypes = msgOptions.getInMediaTypeCodes();
        String[] acceptEncoding = msgOptions.getAcceptEncoding();
        MessageProperties props = new MessageProperties();
        props.setContentType(this.getMediaTypeMapper().getMediaTypeFor(outtype));
        MediaType[] acceptTypes = new MediaType[intypes.length];
        for (int i = 0; i < intypes.length; ++i) {
            acceptTypes[i] = this.getMediaTypeMapper().getMediaTypeFor(intypes[i]);
        }
        props.setAcceptTypes(acceptTypes);
        String soapAction = opname == null ? "" : "\"" + opname + "\"";
        props.setProperty(SOAP_ACTION_HEADER, soapAction);
        if (charset != null) {
            props.setCharset(charset);
        }
        if (acceptEncoding != null) {
            props.setAcceptEncoding(acceptEncoding);
        }
        return props;
    }

    public String getOperationName(InConnection conn) throws IOException {
        String opname = conn.getProperty(SOAP_ACTION_HEADER);
        if (opname != null && opname.startsWith("\"") && opname.endsWith("\"")) {
            opname = opname.substring(1, opname.length() - 1);
        }
        return opname;
    }

    static {
        s_exceptionHandlerFactoryWithTrace11 = new ServiceExceptionHandlerFactory(){

            public ServiceExceptionHandler createServiceExceptionHandler() {
                return new SoapFaultHandler(SoapVersion.SOAP1_1, true);
            }
        };
        s_exceptionHandlerFactoryNoTrace11 = new ServiceExceptionHandlerFactory(){

            public ServiceExceptionHandler createServiceExceptionHandler() {
                return new SoapFaultHandler(SoapVersion.SOAP1_1, false);
            }
        };
        s_service11Factory = new ServiceFactory(){

            public Service createInstance(ServiceDefinition sdef) throws WsException {
                return new SoapService(sdef, s_soap11MediaTypeMapper, new SoapProcessor11(), SoapProtocol11.getDefaultExceptionHandlerFactory(sdef.getIncludeStackTraceOnFault()));
            }
        };
        s_soap11MediaTypeMapper = new MediaTypeMapper(){

            public MediaType getMediaTypeFor(String code) throws WsConfigurationException {
                if (code == null || "xml".equals(code)) {
                    return CodecDirectory.TEXT_XML_MEDIA_TYPE;
                }
                MediaType type = new MediaType("application", "soap+" + code);
                if (!CodecDirectory.hasCodecFor(type)) {
                    throw new WsConfigurationException("No codec available for media type '" + type + "' based on media type code '" + code + "' with protocol SOAP 1.1");
                }
                return type;
            }
        };
    }
}

