/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.IOException;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXException;
import org.jibx.ws.WsException;
import org.jibx.ws.io.XmlReaderWrapper;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.transport.InConnection;

public abstract class SoapReader {
    protected final XmlReaderWrapper m_wrapper;
    private final IXMLReader m_reader;
    private final InConnection m_conn;
    protected final String m_uri;

    SoapReader(InConnection conn, String uri) throws IOException, WsException {
        this.m_conn = conn;
        this.m_conn.init();
        this.m_reader = conn.getReader();
        this.m_wrapper = XmlReaderWrapper.createXmlReaderWrapper(this.m_reader);
        this.m_uri = uri;
    }

    public IXMLReader getReader() {
        return this.m_reader;
    }

    public void startMessage() throws WsException {
        try {
            this.m_wrapper.toStart();
            if (!this.m_wrapper.isAtStart(this.m_uri, "Envelope")) {
                throw new WsException("Message does not begin with SOAP Envelope");
            }
            this.m_wrapper.parsePastStartTag(this.m_uri, "Envelope");
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of SOAP message.", e);
        }
    }

    public boolean hasHeaders() throws WsException {
        boolean isStartHeader;
        try {
            isStartHeader = this.m_wrapper.isAtStart(this.m_uri, "Header");
            if (isStartHeader) {
                this.m_wrapper.parsePastStartTag(this.m_uri, "Header");
                if (this.endHeader()) {
                    isStartHeader = false;
                } else {
                    this.m_wrapper.toStart();
                }
            }
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of header.", e);
        }
        return isStartHeader;
    }

    public boolean endHeader() throws WsException {
        boolean isEndHeader;
        try {
            isEndHeader = this.m_wrapper.isAtEnd(this.m_uri, "Header");
            if (isEndHeader) {
                this.m_wrapper.parsePastEndTag(this.m_uri, "Header");
            }
        }
        catch (JiBXException e) {
            throw new WsException("Error reading end of header.", e);
        }
        return isEndHeader;
    }

    public boolean hasNonEmptyBody() throws WsException {
        try {
            if (this.m_wrapper.isAtEnd(this.m_uri, "Body")) {
                return false;
            }
            this.m_wrapper.toStart();
        }
        catch (JiBXException e) {
            throw new WsException("Error checking for empty SOAP Body.", e);
        }
        return true;
    }

    public void startBody() throws WsException {
        try {
            this.m_wrapper.parsePastStartTag(this.m_uri, "Body");
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of SOAP Body.", e);
        }
    }

    public void endBody() throws WsException {
        try {
            this.m_wrapper.parsePastEndTag(this.m_uri, "Body");
        }
        catch (JiBXException e) {
            throw new WsException("Expected end tag for SOAP body.", e);
        }
    }

    public abstract SoapFault startFault() throws WsException;

    public abstract boolean startFaultDetail() throws WsException;

    public abstract void endFaultDetail() throws WsException;

    public void endFault() throws WsException {
        try {
            this.m_wrapper.parsePastEndTag(this.m_uri, "Fault");
        }
        catch (JiBXException e) {
            throw new WsException("Error reading end of fault.", e);
        }
    }

    public void endMessage() throws WsException {
        try {
            this.m_wrapper.parsePastEndTag(this.m_uri, "Envelope");
        }
        catch (JiBXException e) {
            throw new WsException("Expected end tag for SOAP envelope.", e);
        }
    }

    public boolean isBodyFault() throws WsException {
        try {
            return this.m_wrapper.isAtStart(this.m_uri, "Fault");
        }
        catch (JiBXException e) {
            throw new WsException("Error checking for start of SOAP Fault.", e);
        }
    }
}

