/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.IOException;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.ws.WsException;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.soap.SoapReader;
import org.jibx.ws.transport.InConnection;

public final class SoapReader11
extends SoapReader {
    SoapReader11(InConnection conn) throws IOException, WsException {
        super(conn, "http://schemas.xmlsoap.org/soap/envelope/");
    }

    public SoapFault startFault() throws WsException {
        try {
            this.m_wrapper.parsePastStartTag(this.m_uri, "Fault");
            QName code = this.createQName(this.m_wrapper.parseElementText("", "faultcode"));
            String fault = this.m_wrapper.parseElementText("", "faultstring");
            String actor = null;
            if (this.m_wrapper.isAtStart("", "faultactor")) {
                actor = this.m_wrapper.parseElementText("", "faultactor");
            }
            return new SoapFault(code, fault, actor);
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of fault.", e);
        }
    }

    public boolean startFaultDetail() throws WsException {
        try {
            if (this.m_wrapper.isAtStart("", "detail")) {
                this.m_wrapper.parsePastStartTag("", "detail");
                return true;
            }
            return false;
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of fault detail.", e);
        }
    }

    public void endFaultDetail() throws WsException {
        try {
            this.m_wrapper.parsePastEndTag("", "detail");
        }
        catch (JiBXException e) {
            throw new WsException("Error reading end of fault detail.", e);
        }
    }

    private QName createQName(String str) {
        QName qname = null;
        if (str != null) {
            int i = str.indexOf(58);
            if (i == -1) {
                qname = new QName(str);
            } else {
                String prefix = str.substring(0, i);
                String name = str.substring(i + 1);
                String uri = this.m_wrapper.getReader().getNamespace(prefix);
                qname = new QName(uri, prefix, name);
            }
        }
        return qname;
    }
}

