/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.IOException;
import org.jibx.runtime.IXMLWriter;
import org.jibx.ws.WsException;
import org.jibx.ws.soap.SoapConstants;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.transport.OutConnection;

abstract class SoapWriter {
    protected static final int NO_NS_IDX = 0;
    protected static final int SOAP_NS_IDX = 2;
    private final OutConnection m_connection;
    protected final IXMLWriter m_writer;
    protected final String m_uri;
    protected boolean m_customFaultCodeNS;

    public SoapWriter(OutConnection conn, String uri) throws IOException, WsException {
        this.m_connection = conn;
        this.m_uri = uri;
        this.m_writer = conn.getNormalWriter(new String[]{"", "http://www.w3.org/XML/1998/namespace", uri});
    }

    public IXMLWriter getWriter() {
        return this.m_writer;
    }

    public void startMessage() throws IOException {
        this.startMessage(null);
    }

    public void startMessage(String encodingStyle) throws IOException {
        this.m_writer.startTagNamespaces(2, "Envelope", new int[]{2}, SoapConstants.SOAP_PREFIX_ARRAY);
        if (encodingStyle != null) {
            this.m_writer.addAttribute(2, "encodingStyle", encodingStyle);
        }
        this.m_writer.closeStartTag();
    }

    public void startHeader() throws IOException {
        this.m_writer.startTagClosed(2, "Header");
    }

    public void endHeader() throws IOException {
        this.m_writer.endTag(2, "Header");
    }

    public void startBody() throws IOException {
        this.m_writer.startTagClosed(2, "Body");
    }

    public void endBody() throws IOException {
        this.m_writer.endTag(2, "Body");
        this.m_writer.endTag(2, "Envelope");
    }

    public abstract void startFault(SoapFault var1) throws IOException;

    public abstract void startFaultDetail() throws IOException;

    public abstract void endFaultDetail() throws IOException;

    public void endFault() throws IOException {
        this.m_writer.endTag(2, "Fault");
        if (this.m_customFaultCodeNS) {
            this.m_writer.popExtensionNamespaces();
        }
    }

    public void sendMessageCompletely() throws IOException {
        this.m_connection.close();
    }

    public void abortMessage() throws IOException {
        this.m_connection.close();
    }

    protected void writeTextElement(int nsi, String elementName, String text) throws IOException {
        this.m_writer.startTagClosed(nsi, elementName);
        this.m_writer.writeTextContent(text);
        this.m_writer.endTag(nsi, elementName);
    }
}

