/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.IOException;
import org.jibx.ws.WsException;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.soap.SoapWriter;
import org.jibx.ws.transport.OutConnection;

final class SoapWriter12
extends SoapWriter {
    public SoapWriter12(OutConnection conn) throws IOException, WsException {
        super(conn, "http://www.w3.org/2003/05/soap-envelope");
    }

    public void startFault(SoapFault fault) throws IOException {
        String faultCode = null;
        String uri = fault.getFaultCode().getUri();
        String prefix = fault.getFaultCode().getPrefix();
        if (this.m_uri.equals(uri)) {
            this.m_customFaultCodeNS = false;
            this.m_writer.startTagClosed(2, "Fault");
            faultCode = "SOAP:" + fault.getFaultCode().getName();
        } else {
            this.m_customFaultCodeNS = true;
            int base = this.m_writer.getNamespaceCount();
            int[] indexes = new int[]{base};
            String[] uris = new String[]{uri};
            String[] prefs = new String[]{prefix};
            this.m_writer.pushExtensionNamespaces(uris);
            this.m_writer.startTagNamespaces(2, "Fault", indexes, prefs);
            this.m_writer.closeStartTag();
            faultCode = prefix + ":" + fault.getFaultCode().getName();
        }
        this.writeTextElement(0, "faultcode", faultCode);
        this.writeTextElement(0, "faultstring", fault.getFaultString());
        if (fault.getFaultActor() != null) {
            this.writeTextElement(0, "faultactor", fault.getFaultActor());
        }
    }

    public void startFaultDetail() throws IOException {
        this.m_writer.startTagClosed(0, "detail");
    }

    public void endFaultDetail() throws IOException {
        this.m_writer.endTag(0, "detail");
    }

    public void endFault() throws IOException {
        this.m_writer.endTag(2, "Fault");
        if (this.m_customFaultCodeNS) {
            this.m_writer.popExtensionNamespaces();
        }
    }
}

