/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jibx.ws.transport.Transport;
import org.jibx.ws.transport.TransportOptions;

public final class TransportDirectory {
    private static final String TRANSPORT_PROPERTIES_PATH = "/transport.properties";
    private static final Map s_protocolMap = new HashMap();

    private TransportDirectory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void loadProperties(String path) {
        InputStream stream = null;
        try {
            try {
                Properties props = new Properties();
                stream = TransportDirectory.class.getResourceAsStream(path);
                if (stream == null) {
                    throw new RuntimeException("Unable to load required properties file '" + path + '\'');
                }
                props.load(stream);
                for (String string : props.keySet()) {
                    String classname = props.getProperty(string);
                    try {
                        Class<?> clas = TransportDirectory.class.getClassLoader().loadClass(classname);
                        Object inst = clas.newInstance();
                        if (!(inst instanceof Transport)) throw new IllegalStateException("Class " + classname + ", specified for protocol '" + string + "', is not an org.jibx.ws.transport.Transport implementation");
                        s_protocolMap.put(string.toLowerCase(), inst);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Unable to load transport class " + classname);
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException("Error creating an instance of transport class " + classname + ": " + e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Unable to create an instance of transport class " + classname);
                    }
                }
                Object var9_12 = null;
                if (stream == null) return;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load required properties file '" + path + '\'');
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        stream.close();
        return;
    }

    public static Transport getTransport(String endpoint) {
        Transport transport = null;
        int split = endpoint.indexOf(58);
        if (split > 0) {
            String protocol = endpoint.substring(0, split);
            transport = (Transport)s_protocolMap.get(protocol.toLowerCase());
            if (transport == null) {
                throw new IllegalArgumentException("No transport defined for protocol '" + protocol + "' of endpoint '" + endpoint + "'");
            }
        } else {
            throw new IllegalArgumentException("Unrecognized endpoint '" + endpoint + "' - missing required protocol");
        }
        return transport;
    }

    public static TransportOptions newTransportOptions(String endpoint) {
        return TransportDirectory.getTransport(endpoint).newTransportOptions();
    }

    static {
        TransportDirectory.loadProperties(TRANSPORT_PROPERTIES_PATH);
    }
}

