/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.transport.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.MessageContext;
import org.jibx.ws.io.CopiedInputStream;
import org.jibx.ws.transport.interceptor.InputStreamInterceptor;

public final class CopiedInputStreamInterceptor
implements InputStreamInterceptor {
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private final OutputStream m_os;
    private final String m_attributeName;
    private MessageContext m_ctx;

    public CopiedInputStreamInterceptor(String attributeName) {
        this.m_attributeName = attributeName;
        this.m_os = new ByteArrayOutputStream(4096);
    }

    public CopiedInputStreamInterceptor(OutputStream copyStream) {
        this.m_attributeName = null;
        this.m_os = copyStream;
    }

    public void setMessageContext(InContext ctx) {
        this.m_ctx = ctx;
    }

    public InputStream intercept(InputStream inputStream) {
        return new CopiedInputStream(inputStream, this.m_os);
    }

    public void inputComplete() {
        if (this.m_ctx != null && this.m_attributeName != null) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.m_os;
            this.m_ctx.setAttribute(this.m_attributeName, baos.toByteArray());
            baos.reset();
        }
    }
}

