/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.transport.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.jibx.ws.context.MessageContext;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.io.CopiedOutputStream;
import org.jibx.ws.transport.interceptor.OutputStreamInterceptor;

public final class CopiedOutputStreamInterceptor
implements OutputStreamInterceptor {
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private final OutputStream m_copyStream;
    private final String m_attributeName;
    private MessageContext m_ctx;

    public CopiedOutputStreamInterceptor(String attributeName) {
        this.m_attributeName = attributeName;
        this.m_copyStream = new ByteArrayOutputStream(4096);
    }

    public CopiedOutputStreamInterceptor(OutputStream copyStream) {
        this.m_attributeName = null;
        this.m_copyStream = copyStream;
    }

    public void setMessageContext(OutContext ctx) {
        this.m_ctx = ctx;
    }

    public OutputStream intercept(OutputStream outputStream) {
        return new CopiedOutputStream(outputStream, this.m_copyStream);
    }

    public void outputComplete() {
        if (this.m_ctx != null && this.m_attributeName != null) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.m_copyStream;
            this.m_ctx.setAttribute(this.m_attributeName, baos.toByteArray());
            baos.reset();
        }
    }
}

